/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric;

import java.util.concurrent.atomic.AtomicReference;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmHooks;
import net.blay09.mods.balm.api.entity.BalmEntity;
import net.blay09.mods.balm.api.entity.BalmPlayer;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.fabricmc.fabric.api.item.v1.FabricItemStack;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1752;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricBalmHooks
implements BalmHooks {
    private final AtomicReference<MinecraftServer> currentServer = new AtomicReference();

    public void initialize() {
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> this.currentServer.set(event.getServer()));
        Balm.getEvents().onEvent(ServerStoppedEvent.class, event -> this.currentServer.set(null));
    }

    @Override
    public boolean blockGrowFeature(class_1937 level, class_5819 random, class_2338 pos, @Nullable class_6880<class_2975<?, ?>> holder) {
        return true;
    }

    @Override
    public boolean growCrop(class_1799 itemStack, class_1937 level, class_2338 pos, @Nullable class_1657 player) {
        return class_1752.method_7720((class_1799)itemStack, (class_1937)level, (class_2338)pos);
    }

    @Override
    public class_2487 getPersistentData(class_1297 entity) {
        return ((BalmEntity)entity).getFabricBalmData();
    }

    @Override
    public void curePotionEffects(class_1309 entity, class_1799 curativeItem) {
        entity.method_6012();
    }

    @Override
    public boolean isFakePlayer(class_1657 player) {
        return false;
    }

    @Override
    public class_1799 getCraftingRemainingItem(class_1799 itemStack) {
        class_1799 class_17992 = itemStack;
        if (class_17992 instanceof FabricItemStack) {
            FabricItemStack fabricItemStack = (FabricItemStack)class_17992;
            return fabricItemStack.getRecipeRemainder();
        }
        class_1792 craftingRemainingItem = itemStack.method_7909().method_7858();
        if (craftingRemainingItem != null) {
            return new class_1799((class_1935)craftingRemainingItem);
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1767 getColor(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof class_1769) {
            return ((class_1769)itemStack.method_7909()).method_7802();
        }
        return null;
    }

    @Override
    public boolean canItemsStack(class_1799 first, class_1799 second) {
        return !first.method_7960() && class_1799.method_31577((class_1799)first, (class_1799)second);
    }

    @Override
    public int getBurnTime(class_1799 itemStack) {
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)itemStack.method_7909());
        return burnTime != null ? burnTime : 0;
    }

    @Override
    public void setBurnTime(class_1792 item, int burnTime) {
        FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTime);
    }

    @Override
    public void firePlayerCraftingEvent(class_1657 player, class_1799 crafted, class_1263 craftMatrix) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean useFluidTank(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        int filled;
        class_2586 blockEntity = level.method_8321(pos);
        FluidTank fluidTank = Balm.getProviders().getProvider(blockEntity, FluidTank.class);
        if (fluidTank == null) return false;
        class_1799 handItem = player.method_5998(hand);
        if (handItem.method_7909() == class_1802.field_8550) {
            class_1792 bucketItem;
            int drained = fluidTank.drain(fluidTank.getFluid(), 1000, true);
            if (drained < 1000 || (bucketItem = fluidTank.getFluid().method_15774()) == null || bucketItem == class_1802.field_8162) return false;
            class_1799 bucketItemStack = new class_1799((class_1935)bucketItem);
            if (handItem.method_7947() > 1) {
                if (!player.method_7270(bucketItemStack)) return false;
                fluidTank.getFluid().method_32359().ifPresent(sound -> player.method_5783(sound, 1.0f, 1.0f));
                handItem.method_7934(1);
                fluidTank.drain(fluidTank.getFluid(), 1000, false);
                return true;
            }
            fluidTank.getFluid().method_32359().ifPresent(sound -> player.method_5783(sound, 1.0f, 1.0f));
            player.method_6122(hand, bucketItemStack);
            fluidTank.drain(fluidTank.getFluid(), 1000, false);
            return true;
        }
        class_3611 fluid = class_7923.field_41173.method_10220().filter(it -> it.method_15774() == handItem.method_7909()).findFirst().orElse(null);
        if (fluid == null || fluid.method_15780(class_3612.field_15906) || (filled = fluidTank.fill(fluid, 1000, true)) < 1000) return false;
        if (handItem.method_7947() > 1) {
            class_1799 restItem = Balm.getHooks().getCraftingRemainingItem(handItem);
            if (!player.method_7270(restItem)) return false;
            player.method_5783(class_3417.field_14834, 1.0f, 1.0f);
            fluidTank.getFluid().method_32359().ifPresent(sound -> player.method_5783(sound, 1.0f, 1.0f));
            handItem.method_7934(1);
            fluidTank.fill(fluid, 1000, false);
            return true;
        }
        player.method_5783(class_3417.field_14834, 1.0f, 1.0f);
        player.method_6122(hand, Balm.getHooks().getCraftingRemainingItem(handItem));
        fluidTank.fill(fluid, 1000, false);
        return true;
    }

    @Override
    public boolean isShield(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1819;
    }

    @Override
    public boolean isRepairable(class_1799 itemStack) {
        Integer repairCost = (Integer)itemStack.method_7909().method_57347().method_57829(class_9334.field_49639);
        return repairCost != null && repairCost > 0;
    }

    @Override
    public void setForcedPose(class_1657 player, class_4050 pose) {
        ((BalmPlayer)player).setForcedPose(pose);
    }

    @Override
    public MinecraftServer getServer() {
        return this.currentServer.get();
    }

    @Override
    public double getBlockReachDistance(class_1657 player) {
        return 4.5 + (player.method_7337() ? 0.5 : 0.0);
    }
}

