/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.mixin;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private static final ThreadLocal<LivingFallEvent> balmCurrentFallEvent = new ThreadLocal();

    @ModifyVariable(method={"actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setAbsorptionAmount(F)V"), index=2, argsOnly=true)
    private float actuallyHurt(float damageAmount, class_1282 damageSource) {
        LivingDamageEvent event = new LivingDamageEvent((class_1309)this, damageSource, damageAmount);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getDamageAmount();
    }

    @Inject(method={"causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(float distance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> callbackInfo) {
        LivingFallEvent event = new LivingFallEvent((class_1309)this);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            callbackInfo.setReturnValue((Object)false);
        }
        balmCurrentFallEvent.set(event);
    }

    @Inject(method={"calculateFallDamage(FF)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void calculateFallDamage(float f, float g, CallbackInfoReturnable<Integer> cir) {
        LivingFallEvent event = balmCurrentFallEvent.get();
        if (event != null && event.getFallDamageOverride() != null) {
            cir.setReturnValue((Object)event.getFallDamageOverride().intValue());
            balmCurrentFallEvent.set(null);
        }
    }

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyHealing(float heal) {
        class_1309 entity = (class_1309)this;
        LivingHealEvent event = new LivingHealEvent(entity, heal);
        return event.isCanceled() ? 0.0f : heal;
    }
}

