/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.beam;

import com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.derock.svcmusic.apachehttp.client.methods.HttpGet;
import dev.derock.svcmusic.apachehttp.client.methods.HttpUriRequest;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamSegmentUrlProvider
extends M3uStreamSegmentUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(BeamSegmentUrlProvider.class);
    private final String channelId;
    private String streamSegmentPlaylistUrl;

    public BeamSegmentUrlProvider(String channelId) {
        super(null);
        this.channelId = channelId;
    }

    @Override
    protected String getQualityFromM3uDirective(ExtendedM3uParser.Line directiveLine) {
        return directiveLine.directiveArguments.get("NAME");
    }

    @Override
    protected String fetchSegmentPlaylistUrl(HttpInterface httpInterface) throws IOException {
        if (this.streamSegmentPlaylistUrl != null) {
            return this.streamSegmentPlaylistUrl;
        }
        HttpGet jsonRequest = new HttpGet("https://mixer.com/api/v1/channels/" + this.channelId + "/manifest.light2");
        JsonBrowser lightManifest = HttpClientTools.fetchResponseAsJson(httpInterface, jsonRequest);
        if (lightManifest == null) {
            throw new IllegalStateException("Did not find light manifest at " + jsonRequest.getURI());
        }
        HttpGet manifestRequest = new HttpGet("https://mixer.com" + lightManifest.get("hlsSrc").text());
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = this.loadChannelStreamsList(HttpClientTools.fetchResponseLines(httpInterface, manifestRequest, "mixer channel streams list"));
        if (streams.isEmpty()) {
            throw new IllegalStateException("No streams available on channel.");
        }
        M3uStreamSegmentUrlProvider.ChannelStreamInfo stream = streams.get(0);
        log.debug("Chose stream with quality {} from url {}", (Object)stream.quality, (Object)stream.url);
        this.streamSegmentPlaylistUrl = stream.url;
        return this.streamSegmentPlaylistUrl;
    }

    @Override
    protected HttpUriRequest createSegmentGetRequest(String url) {
        return new HttpGet(url);
    }
}

