/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.yamusic;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.yamusic.DefaultYandexMusicDirectUrlLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.DefaultYandexMusicPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.DefaultYandexMusicTrackLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.DefaultYandexSearchProvider;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexHttpContextFilter;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicDirectUrlLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicSearchResultLoader;
import com.sedmelluq.discord.lavaplayer.source.yamusic.YandexMusicTrackLoader;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.http.MultiHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.derock.svcmusic.apachehttp.client.config.RequestConfig;
import dev.derock.svcmusic.apachehttp.impl.client.HttpClientBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YandexMusicAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String PROTOCOL_REGEX = "https?://";
    private static final String DOMAIN_REGEX = "music\\.yandex\\.[a-zA-Z]+";
    private static final String TRACK_ID_REGEX = "track/([0-9]+)(?:\\?.*|)";
    private static final String ALBUM_ID_REGEX = "album/([0-9]+)(?:\\?.*|)";
    private static final String ARTIST_ID_REGEX = "artist/([0-9]+)(?:/tracks)?(?:\\?.*|)";
    private static final String PLAYLIST_ID_REGEX = "playlists/([0-9]+)(?:\\?.*|)";
    private static final String USER_REGEX = "users/(.+)";
    private static final Pattern trackUrlPattern = Pattern.compile("^https?://music\\.yandex\\.[a-zA-Z]+/album/([0-9]+)(?:\\?.*|)/track/([0-9]+)(?:\\?.*|)$");
    private static final Pattern shortTrackUrlPattern = Pattern.compile("^https?://music\\.yandex\\.[a-zA-Z]+/track/([0-9]+)(?:\\?.*|)$");
    private static final Pattern albumUrlPattern = Pattern.compile("^https?://music\\.yandex\\.[a-zA-Z]+/album/([0-9]+)(?:\\?.*|)$");
    private static final Pattern artistUrlPattern = Pattern.compile("^https?://music\\.yandex\\.[a-zA-Z]+/artist/([0-9]+)(?:/tracks)?(?:\\?.*|)$");
    private static final Pattern playlistUrlPattern = Pattern.compile("^https?://music\\.yandex\\.[a-zA-Z]+/users/(.+)/playlists/([0-9]+)(?:\\?.*|)$");
    private final boolean allowSearch;
    private final HttpInterfaceManager httpInterfaceManager;
    private final ExtendedHttpConfigurable combinedHttpConfiguration;
    private final YandexMusicDirectUrlLoader directUrlLoader;
    private final YandexMusicTrackLoader trackLoader;
    private final YandexMusicPlaylistLoader playlistLoader;
    private final YandexMusicSearchResultLoader searchResultLoader;

    public YandexMusicAudioSourceManager() {
        this(true);
    }

    public YandexMusicAudioSourceManager(boolean allowSearch) {
        this(allowSearch, new DefaultYandexMusicTrackLoader(), new DefaultYandexMusicPlaylistLoader(), new DefaultYandexMusicDirectUrlLoader(), new DefaultYandexSearchProvider());
    }

    public YandexMusicAudioSourceManager(boolean allowSearch, YandexMusicTrackLoader trackLoader, YandexMusicPlaylistLoader playlistLoader, YandexMusicDirectUrlLoader directUrlLoader, YandexMusicSearchResultLoader searchResultLoader) {
        this.allowSearch = allowSearch;
        this.trackLoader = trackLoader;
        this.playlistLoader = playlistLoader;
        this.directUrlLoader = directUrlLoader;
        this.searchResultLoader = searchResultLoader;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
        this.httpInterfaceManager.setHttpContextFilter(new YandexHttpContextFilter());
        this.combinedHttpConfiguration = new MultiHttpConfigurable(Arrays.asList(this.httpInterfaceManager, trackLoader.getHttpConfiguration(), playlistLoader.getHttpConfiguration(), directUrlLoader.getHttpConfiguration(), searchResultLoader.getHttpConfiguration()));
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher matcher = trackUrlPattern.matcher(reference.identifier);
        if (matcher.matches()) {
            return this.trackLoader.loadTrack(matcher.group(1), matcher.group(2), this::getTrack);
        }
        matcher = shortTrackUrlPattern.matcher(reference.identifier);
        if (matcher.matches()) {
            return this.trackLoader.loadTrack("", matcher.group(1), this::getTrack);
        }
        matcher = playlistUrlPattern.matcher(reference.identifier);
        if (matcher.matches()) {
            return this.playlistLoader.loadPlaylist(matcher.group(1), matcher.group(2), "tracks", this::getTrack);
        }
        matcher = albumUrlPattern.matcher(reference.identifier);
        if (matcher.matches()) {
            return this.playlistLoader.loadPlaylist(matcher.group(1), "volumes", this::getTrack);
        }
        matcher = artistUrlPattern.matcher(reference.identifier);
        if (matcher.matches()) {
            return this.playlistLoader.loadPlaylist(matcher.group(1), "popularTracks", this::getTrack);
        }
        if (this.allowSearch) {
            return this.searchResultLoader.loadSearchResult(reference.identifier, this.playlistLoader, this::getTrack);
        }
        return null;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new YandexMusicAudioTrack(trackInfo, this);
    }

    public AudioTrack getTrack(AudioTrackInfo info) {
        return new YandexMusicAudioTrack(info, this);
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
        this.trackLoader.shutdown();
        this.playlistLoader.shutdown();
        this.searchResultLoader.shutdown();
        this.directUrlLoader.shutdown();
    }

    public YandexMusicDirectUrlLoader getDirectUrlLoader() {
        return this.directUrlLoader;
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.combinedHttpConfiguration.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.combinedHttpConfiguration.configureBuilder(configurator);
    }

    public ExtendedHttpConfigurable getHttpConfiguration() {
        return this.combinedHttpConfiguration;
    }

    public ExtendedHttpConfigurable getMainHttpConfiguration() {
        return this.httpInterfaceManager;
    }

    public ExtendedHttpConfigurable getTrackLHttpConfiguration() {
        return this.trackLoader.getHttpConfiguration();
    }

    public ExtendedHttpConfigurable getPlaylistLHttpConfiguration() {
        return this.playlistLoader.getHttpConfiguration();
    }

    public ExtendedHttpConfigurable getDirectUrlLHttpConfiguration() {
        return this.directUrlLoader.getHttpConfiguration();
    }

    public ExtendedHttpConfigurable getSearchHttpConfiguration() {
        return this.searchResultLoader.getHttpConfiguration();
    }

    @Override
    public String getSourceName() {
        return "yandex-music";
    }
}

