/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.client;

import dev.derock.svcmusic.apachehttp.HttpException;
import dev.derock.svcmusic.apachehttp.HttpHost;
import dev.derock.svcmusic.apachehttp.HttpRequest;
import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.client.ClientProtocolException;
import dev.derock.svcmusic.apachehttp.client.config.RequestConfig;
import dev.derock.svcmusic.apachehttp.client.methods.CloseableHttpResponse;
import dev.derock.svcmusic.apachehttp.client.methods.Configurable;
import dev.derock.svcmusic.apachehttp.client.methods.HttpExecutionAware;
import dev.derock.svcmusic.apachehttp.client.methods.HttpRequestWrapper;
import dev.derock.svcmusic.apachehttp.client.protocol.HttpClientContext;
import dev.derock.svcmusic.apachehttp.conn.ClientConnectionManager;
import dev.derock.svcmusic.apachehttp.conn.ClientConnectionRequest;
import dev.derock.svcmusic.apachehttp.conn.HttpClientConnectionManager;
import dev.derock.svcmusic.apachehttp.conn.ManagedClientConnection;
import dev.derock.svcmusic.apachehttp.conn.routing.HttpRoute;
import dev.derock.svcmusic.apachehttp.conn.scheme.SchemeRegistry;
import dev.derock.svcmusic.apachehttp.impl.DefaultConnectionReuseStrategy;
import dev.derock.svcmusic.apachehttp.impl.client.CloseableHttpClient;
import dev.derock.svcmusic.apachehttp.impl.client.DefaultConnectionKeepAliveStrategy;
import dev.derock.svcmusic.apachehttp.impl.execchain.MinimalClientExec;
import dev.derock.svcmusic.apachehttp.params.BasicHttpParams;
import dev.derock.svcmusic.apachehttp.params.HttpParams;
import dev.derock.svcmusic.apachehttp.protocol.BasicHttpContext;
import dev.derock.svcmusic.apachehttp.protocol.HttpContext;
import dev.derock.svcmusic.apachehttp.protocol.HttpRequestExecutor;
import dev.derock.svcmusic.apachehttp.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

