/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.cookie;

import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.conn.util.InetAddressUtils;
import dev.derock.svcmusic.apachehttp.cookie.ClientCookie;
import dev.derock.svcmusic.apachehttp.cookie.CommonCookieAttributeHandler;
import dev.derock.svcmusic.apachehttp.cookie.Cookie;
import dev.derock.svcmusic.apachehttp.cookie.CookieOrigin;
import dev.derock.svcmusic.apachehttp.cookie.CookieRestrictionViolationException;
import dev.derock.svcmusic.apachehttp.cookie.MalformedCookieException;
import dev.derock.svcmusic.apachehttp.cookie.SetCookie;
import dev.derock.svcmusic.apachehttp.util.Args;
import dev.derock.svcmusic.apachehttp.util.TextUtils;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicDomainHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        if (value.endsWith(".")) {
            return;
        }
        String domain = value;
        if (domain.startsWith(".")) {
            domain = domain.substring(1);
        }
        domain = domain.toLowerCase(Locale.ROOT);
        cookie.setDomain(domain);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            throw new CookieRestrictionViolationException("Cookie 'domain' may not be null");
        }
        if (!host.equals(domain) && !BasicDomainHandler.domainMatch(domain, host)) {
            throw new CookieRestrictionViolationException("Illegal 'domain' attribute \"" + domain + "\". Domain of origin: \"" + host + "\"");
        }
    }

    static boolean domainMatch(String domain, String host) {
        String normalizedDomain;
        if (InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host)) {
            return false;
        }
        String string = normalizedDomain = domain.startsWith(".") ? domain.substring(1) : domain;
        if (host.endsWith(normalizedDomain)) {
            int prefix = host.length() - normalizedDomain.length();
            if (prefix == 0) {
                return true;
            }
            if (prefix > 1 && host.charAt(prefix - 1) == '.') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        if (domain.startsWith(".")) {
            domain = domain.substring(1);
        }
        if (host.equals(domain = domain.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            return BasicDomainHandler.domainMatch(domain, host);
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

