/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.cookie;

import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.cookie.CommonCookieAttributeHandler;
import dev.derock.svcmusic.apachehttp.cookie.Cookie;
import dev.derock.svcmusic.apachehttp.cookie.CookieOrigin;
import dev.derock.svcmusic.apachehttp.cookie.CookieRestrictionViolationException;
import dev.derock.svcmusic.apachehttp.cookie.MalformedCookieException;
import dev.derock.svcmusic.apachehttp.cookie.SetCookie;
import dev.derock.svcmusic.apachehttp.impl.cookie.AbstractCookieAttributeHandler;
import dev.derock.svcmusic.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

