/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.cookie;

import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.cookie.ClientCookie;
import dev.derock.svcmusic.apachehttp.cookie.CommonCookieAttributeHandler;
import dev.derock.svcmusic.apachehttp.cookie.Cookie;
import dev.derock.svcmusic.apachehttp.cookie.CookieOrigin;
import dev.derock.svcmusic.apachehttp.cookie.CookieRestrictionViolationException;
import dev.derock.svcmusic.apachehttp.cookie.MalformedCookieException;
import dev.derock.svcmusic.apachehttp.cookie.SetCookie;
import dev.derock.svcmusic.apachehttp.cookie.SetCookie2;
import dev.derock.svcmusic.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

