/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.protocol;

import dev.derock.svcmusic.apachehttp.HttpException;
import dev.derock.svcmusic.apachehttp.HttpRequest;
import dev.derock.svcmusic.apachehttp.HttpRequestInterceptor;
import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.protocol.HttpContext;
import dev.derock.svcmusic.apachehttp.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

