/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.protocol;

import dev.derock.svcmusic.apachehttp.HttpException;
import dev.derock.svcmusic.apachehttp.HttpResponse;
import dev.derock.svcmusic.apachehttp.HttpResponseInterceptor;
import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.protocol.HttpContext;
import dev.derock.svcmusic.apachehttp.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

