/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.audio;

import com.sedmelluq.discord.lavaplayer.filter.equalizer.EqualizerFactory;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import dev.derock.svcmusic.SimpleVoiceChatMusic;
import dev.derock.svcmusic.VoiceChatPlugin;
import dev.derock.svcmusic.audio.GroupSettingsManager;
import dev.derock.svcmusic.audio.MusicManager;
import dev.derock.svcmusic.audio.TrackScheduler;
import dev.derock.svcmusic.util.Constants;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GroupManager {
    private final Group group;
    private final AudioPlayer lavaplayer;
    private final MinecraftServer server;
    private final BlockingQueue<AudioTrack> queue;
    private final GroupSettingsManager settingsStore;
    private final ConcurrentHashMap<UUID, StaticAudioChannel> connections = new ConcurrentHashMap();
    private final MutableAudioFrame currentFrame;
    private final EqualizerFactory equalizer = new EqualizerFactory();
    @Nullable
    private ScheduledFuture<?> audioFrameSendingTask = null;
    @Nullable
    private ScheduledFuture<?> playerTrackingTask = null;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "SVCGroupMusicExecutor");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> SimpleVoiceChatMusic.LOGGER.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e));
        return thread;
    });

    public GroupManager(Group group, AudioPlayer player, MinecraftServer server) {
        this.group = group;
        this.server = server;
        this.lavaplayer = player;
        this.currentFrame = new MutableAudioFrame();
        this.settingsStore = GroupSettingsManager.getGroup(group);
        this.lavaplayer.setFilterFactory(this.equalizer);
        this.lavaplayer.setFrameBufferDuration(500);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        this.currentFrame.setBuffer(buffer);
        this.queue = new LinkedBlockingQueue<AudioTrack>();
        player.addListener(new TrackScheduler(this));
        this.startGroupTracking();
        this.startAudioFrameSending();
        this.setVolume(this.settingsStore.volume);
        this.setBassBoost(this.settingsStore.bassboost);
    }

    private void startAudioFrameSending() {
        if (this.audioFrameSendingTask != null && !this.audioFrameSendingTask.isDone()) {
            SimpleVoiceChatMusic.LOGGER.info("Not starting new audio frame sending task.");
            return;
        }
        if (this.audioFrameSendingTask != null && this.audioFrameSendingTask.isDone()) {
            SimpleVoiceChatMusic.LOGGER.info("Frame task in stuck state, attempting to revive");
            this.audioFrameSendingTask.cancel(true);
        }
        SimpleVoiceChatMusic.LOGGER.info("Starting new audio frame sending task.");
        this.audioFrameSendingTask = this.executorService.scheduleAtFixedRate(() -> {
            if (VoiceChatPlugin.voicechatServerApi == null) {
                return;
            }
            if (this.lavaplayer == null || this.lavaplayer.isPaused() || this.lavaplayer.getPlayingTrack() == null) {
                return;
            }
            if (this.lavaplayer.provide(this.currentFrame)) {
                for (StaticAudioChannel channel : this.connections.values()) {
                    channel.send(this.currentFrame.getData());
                }
            }
        }, 1000L, 20L, TimeUnit.MILLISECONDS);
    }

    private void startGroupTracking() {
        this.playerTrackingTask = this.executorService.scheduleAtFixedRate(() -> {
            if (VoiceChatPlugin.voicechatServerApi == null) {
                return;
            }
            HashSet<UUID> uuids = new HashSet<UUID>();
            for (class_3222 serverPlayer : this.server.method_3760().method_14571()) {
                Group playerGroup;
                VoicechatConnection playerConnection = VoiceChatPlugin.voicechatServerApi.getConnectionOf(serverPlayer.method_5667());
                if (playerConnection == null || !playerConnection.isConnected() || (playerGroup = playerConnection.getGroup()) == null || playerGroup.getId() != this.group.getId()) continue;
                uuids.add(serverPlayer.method_5667());
                this.connections.computeIfAbsent(serverPlayer.method_5667(), uuid -> {
                    StaticAudioChannel channel = VoiceChatPlugin.voicechatServerApi.createStaticAudioChannel(UUID.randomUUID(), VoiceChatPlugin.voicechatServerApi.fromServerLevel(serverPlayer.method_37908()), playerConnection);
                    if (channel == null) {
                        return null;
                    }
                    channel.setCategory(VoiceChatPlugin.MUSIC_CATEGORY);
                    return channel;
                });
            }
            for (UUID uuid2 : this.connections.keySet()) {
                if (uuids.contains(uuid2)) continue;
                this.connections.remove(uuid2);
            }
            if (this.connections.isEmpty()) {
                SimpleVoiceChatMusic.LOGGER.info("Group {} is now empty. Cleaning up...", (Object)this.group.getName());
                this.cleanup();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public boolean enqueueSong(AudioTrack track) {
        if (!this.lavaplayer.startTrack(track, true)) {
            return this.queue.offer(track);
        }
        return true;
    }

    public BlockingQueue<AudioTrack> getQueue() {
        return this.queue;
    }

    public void nextTrack() {
        this.executorService.execute(() -> {
            AudioTrack track = (AudioTrack)this.queue.poll();
            this.lavaplayer.startTrack(track, false);
            if (track != null) {
                this.startAudioFrameSending();
            } else {
                this.cleanup();
            }
        });
    }

    public AudioPlayer getPlayer() {
        return this.lavaplayer;
    }

    public void broadcast(class_5250 text) {
        this.server.execute(() -> {
            class_3222[] players;
            for (class_3222 player2 : players = (class_3222[])this.server.method_3760().method_14571().stream().filter(player -> this.connections.containsKey(player.method_5667())).toArray(class_3222[]::new)) {
                player2.method_43496((class_2561)text);
            }
        });
    }

    public void cleanup() {
        this.broadcast(class_2561.method_43470((String)"No more songs to play."));
        if (this.audioFrameSendingTask != null) {
            this.audioFrameSendingTask.cancel(true);
        }
        this.lavaplayer.destroy();
        MusicManager.getInstance().deleteGroup(this.group);
        if (this.playerTrackingTask != null) {
            this.playerTrackingTask.cancel(false);
        }
        this.executorService.shutdown();
    }

    public void setBassBoost(float percentage) {
        this.settingsStore.bassboost = percentage;
        float multiplier = percentage / 100.0f;
        for (int i = 0; i < Constants.BASS_BOOST.length; ++i) {
            this.equalizer.setGain(i, Constants.BASS_BOOST[i] * multiplier);
        }
    }

    public void setVolume(int volume) {
        this.settingsStore.volume = volume;
        this.getPlayer().setVolume(volume);
    }

    public final GroupSettingsManager getSettingsStore() {
        return this.settingsStore;
    }
}

