/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.audio;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManagers;
import de.maxhenkel.voicechat.api.Group;
import dev.derock.svcmusic.SimpleVoiceChatMusic;
import dev.derock.svcmusic.audio.GroupManager;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public class MusicManager {
    private static final MusicManager instance = new MusicManager();
    public AudioPlayerManager playerManager;
    private final HashMap<UUID, GroupManager> groups = new HashMap();

    public MusicManager() {
        SimpleVoiceChatMusic.LOGGER.info("Loading sources...");
        this.playerManager = new DefaultAudioPlayerManager();
        this.playerManager.getConfiguration().setFilterHotSwapEnabled(true);
        AudioSourceManagers.registerRemoteSources(this.playerManager, com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager.class);
        YoutubeAudioSourceManager ytSourceManager = new YoutubeAudioSourceManager();
        this.playerManager.registerSourceManager(ytSourceManager);
        SimpleVoiceChatMusic.LOGGER.info("Loaded all sources!");
    }

    public static MusicManager getInstance() {
        return instance;
    }

    public GroupManager getGroup(Group group, MinecraftServer server) {
        if (this.groups.containsKey(group.getId())) {
            return this.groups.get(group.getId());
        }
        GroupManager gm = new GroupManager(group, this.playerManager.createPlayer(), server);
        this.groups.put(group.getId(), gm);
        return gm;
    }

    public GroupManager deleteGroup(Group group) {
        return this.groups.remove(group.getId());
    }

    public void cleanup() {
        for (GroupManager gm : this.groups.values()) {
            gm.cleanup();
        }
        this.groups.clear();
    }
}

