/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.audio;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.derock.svcmusic.SimpleVoiceChatMusic;
import dev.derock.svcmusic.audio.GroupManager;
import dev.derock.svcmusic.util.ModUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class SearchLoadHandler
implements AudioLoadResultHandler {
    protected final class_2168 source;
    protected final GroupManager group;

    public SearchLoadHandler(class_2168 source, GroupManager group) {
        this.source = source;
        this.group = group;
    }

    @Override
    public void trackLoaded(AudioTrack track) {
        this.group.enqueueSong(track);
        if (this.source != null) {
            this.group.broadcast(class_2561.method_43470((String)"Enqueued ").method_10852((class_2561)ModUtils.trackInfo(track.getInfo(), true)).method_27693(" - ").method_10852(Objects.requireNonNull(this.source.method_44023()).method_5477()));
        }
    }

    @Override
    public void playlistLoaded(AudioPlaylist playlist) {
        List<AudioTrack> loaded = playlist.getTracks().subList(0, 5);
        if (this.source != null) {
            class_5250 text = class_2561.method_43470((String)("Found " + loaded.size() + " results: \n"));
            for (AudioTrack track : loaded) {
                text.method_10852((class_2561)class_2561.method_43470((String)"  - ")).method_10852((class_2561)ModUtils.trackInfo(track.getInfo(), true)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"    ")).method_10852((class_2561)class_2561.method_43470((String)"[Click to add to queue]").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/music play \"" + track.getIdentifier() + "\"")))).method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
            }
            this.source.method_9226(() -> text, false);
        }
    }

    @Override
    public void noMatches() {
        if (this.source != null) {
            this.source.method_9226(() -> class_2561.method_43470((String)"No matches found!"), false);
        }
    }

    @Override
    public void loadFailed(FriendlyException exception) {
        if (!exception.severity.equals((Object)FriendlyException.Severity.COMMON)) {
            SimpleVoiceChatMusic.LOGGER.warn("Failed to load track from query", exception);
        }
        if (this.source != null) {
            this.source.method_9226(() -> class_2561.method_43470((String)(exception.severity == FriendlyException.Severity.COMMON ? "Failed to load track: " + exception.getMessage() : "Track failed to load! Check server logs for more information")), false);
        }
    }
}

