/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.cipher;

import dev.lavalink.youtube.cipher.CipherOperation;
import java.util.ArrayList;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;

public class SignatureCipher {
    private final List<CipherOperation> operations = new ArrayList<CipherOperation>();
    public final String nFunction;
    public final String scriptTimestamp;
    public final String rawScript;

    public SignatureCipher(@NotNull String nFunction, @NotNull String timestamp, @NotNull String rawScript) {
        this.nFunction = nFunction;
        this.scriptTimestamp = timestamp;
        this.rawScript = rawScript;
    }

    public String apply(@NotNull String text) {
        StringBuilder builder = new StringBuilder(text);
        block5: for (CipherOperation operation : this.operations) {
            switch (operation.type) {
                case SWAP: {
                    int position = operation.parameter % text.length();
                    char temp = builder.charAt(0);
                    builder.setCharAt(0, builder.charAt(position));
                    builder.setCharAt(position, temp);
                    continue block5;
                }
                case REVERSE: {
                    builder.reverse();
                    continue block5;
                }
                case SLICE: 
                case SPLICE: {
                    builder.delete(0, operation.parameter);
                    continue block5;
                }
            }
            throw new IllegalStateException("All branches should be covered");
        }
        return builder.toString();
    }

    public String transform(@NotNull String text, @NotNull ScriptEngine scriptEngine) throws ScriptException, NoSuchMethodException {
        scriptEngine.eval("n=" + this.nFunction);
        String transformed = (String)((Invocable)((Object)scriptEngine)).invokeFunction("n", text);
        return transformed;
    }

    public void addOperation(@NotNull CipherOperation operation) {
        this.operations.add(operation);
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }
}

