/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.clients;

import com.grack.nanojson.JsonStringWriter;
import com.grack.nanojson.JsonWriter;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientConfig {
    private String name;
    private String userAgent;
    private String apiKey;
    private final Map<String, Object> root;

    public ClientConfig() {
        this.root = new HashMap<String, Object>();
        this.userAgent = null;
        this.name = null;
    }

    private ClientConfig(@NotNull Map<String, Object> context, @NotNull String userAgent, @NotNull String name) {
        this.root = context;
        this.userAgent = userAgent;
        this.name = name;
    }

    public ClientConfig copy() {
        return new ClientConfig(new HashMap<String, Object>(this.root), this.userAgent, this.name);
    }

    public ClientConfig withClientName(@NotNull String name) {
        this.name = name;
        this.withClientField("clientName", name);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ClientConfig withUserAgent(@NotNull String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ClientConfig withApiKey(@NotNull String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Map<String, Object> putOnceAndJoin(@NotNull Map<String, Object> on, @NotNull String key) {
        return (Map)on.computeIfAbsent(key, __ -> new HashMap());
    }

    public ClientConfig withClientDefaultScreenParameters() {
        this.withClientField("screenDensityFloat", 1);
        this.withClientField("screenHeightPoints", 1080);
        this.withClientField("screenPixelDensity", 1);
        return this.withClientField("screenWidthPoints", 1920);
    }

    public ClientConfig withThirdPartyEmbedUrl(@NotNull String embedUrl) {
        Map<String, Object> context = this.putOnceAndJoin(this.root, "context");
        Map<String, Object> thirdParty = this.putOnceAndJoin(context, "thirdParty");
        thirdParty.put("embedUrl", embedUrl);
        return this;
    }

    public ClientConfig withPlaybackSignatureTimestamp(@NotNull String signatureTimestamp) {
        Map<String, Object> playbackContext = this.putOnceAndJoin(this.root, "playbackContext");
        Map<String, Object> contentPlaybackContext = this.putOnceAndJoin(playbackContext, "contentPlaybackContext");
        contentPlaybackContext.put("signatureTimestamp", signatureTimestamp);
        return this;
    }

    public ClientConfig withRootField(@NotNull String key, @Nullable Object value) {
        this.root.put(key, value);
        return this;
    }

    public ClientConfig withClientField(@NotNull String key, @Nullable Object value) {
        Map<String, Object> context = this.putOnceAndJoin(this.root, "context");
        Map<String, Object> client = this.putOnceAndJoin(context, "client");
        client.put(key, value);
        return this;
    }

    public ClientConfig withUserField(@NotNull String key, @Nullable Object value) {
        Map<String, Object> context = this.putOnceAndJoin(this.root, "context");
        Map<String, Object> user = this.putOnceAndJoin(context, "user");
        user.put(key, value);
        return this;
    }

    public ClientConfig setAttributes(@NotNull HttpInterface httpInterface) {
        if (this.userAgent != null) {
            httpInterface.getContext().setAttribute("clientUserAgent", this.userAgent);
        }
        return this;
    }

    public String toJsonString() {
        return ((JsonStringWriter)JsonWriter.string().object((Map)this.root)).done();
    }

    public static enum AndroidVersion {
        ANDROID_13("13", 33),
        ANDROID_12("12", 31),
        ANDROID_11("11", 30);

        private final String osVersion;
        private final int sdkVersion;

        private AndroidVersion(String osVersion, int sdkVersion) {
            this.osVersion = osVersion;
            this.sdkVersion = sdkVersion;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public int getSdkVersion() {
            return this.sdkVersion;
        }
    }
}

