/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.clients;

import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.Units;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.clients.ClientConfig;
import dev.lavalink.youtube.clients.ClientOptions;
import dev.lavalink.youtube.clients.skeleton.StreamingNonMusicClient;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TvHtml5Embedded
extends StreamingNonMusicClient {
    public static ClientConfig BASE_CONFIG = new ClientConfig().withApiKey("AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8").withClientName("TVHTML5_SIMPLY_EMBEDDED_PLAYER").withClientField("clientVersion", "2.0").withThirdPartyEmbedUrl("https://www.youtube.com");
    protected ClientOptions options;

    public TvHtml5Embedded() {
        this(ClientOptions.DEFAULT);
    }

    public TvHtml5Embedded(@NotNull ClientOptions options) {
        this.options = options;
    }

    @Override
    @NotNull
    protected ClientConfig getBaseClientConfig(@NotNull HttpInterface httpInterface) {
        return BASE_CONFIG.copy();
    }

    @Override
    @NotNull
    protected JsonBrowser extractPlaylistVideoList(@NotNull JsonBrowser json) {
        return json.get("contents").get("sectionListRenderer").get("contents").index(0).get("playlistVideoListRenderer");
    }

    @Override
    protected void extractPlaylistTracks(@NotNull JsonBrowser json, @NotNull List<AudioTrack> tracks, @NotNull YoutubeAudioSourceManager source) {
        if (!json.get("contents").isNull()) {
            json = json.get("contents");
        }
        if (json.isNull()) {
            return;
        }
        for (JsonBrowser track : json.values()) {
            JsonBrowser item = track.get("videoRenderer");
            JsonBrowser authorJson = item.get("shortBylineText");
            if (authorJson.isNull()) continue;
            String videoId = item.get("videoId").text();
            JsonBrowser titleField = item.get("title");
            String title = titleField.get("simpleText").textOrDefault(titleField.get("runs").index(0).get("text").text());
            String author = authorJson.get("runs").index(0).get("text").textOrDefault("Unknown artist");
            long duration = Units.secondsToMillis(item.get("lengthSeconds").asLong(Long.MAX_VALUE));
            tracks.add(this.buildAudioTrack(source, track, title, author, duration, videoId, false));
        }
    }

    @Override
    @NotNull
    public String getPlayerParams() {
        return WEB_PLAYER_PARAMS;
    }

    @Override
    @NotNull
    public ClientOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean canHandleRequest(@NotNull String identifier) {
        return (!identifier.contains("list=") || identifier.contains("list=RD")) && super.canHandleRequest(identifier);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return BASE_CONFIG.getName();
    }

    @Override
    public AudioItem loadPlaylist(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String playlistId, @Nullable String selectedVideoId) {
        throw new UnsupportedOperationException();
    }
}

