/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui.render;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_367;
import net.minecraft.class_368;
import net.minecraft.class_3928;
import net.minecraft.class_433;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;

public class AdvancementPlaque {
    private final class_367 toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private boolean hasTakenScreenshot = false;
    private class_368.class_369 visibility = class_368.class_369.field_2210;
    private class_310 mc;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(class_367 toastIn, class_310 mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.mc = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public class_367 getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = class_3532.method_15363((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == class_368.class_369.field_2209 ? 1.0f - f : f;
    }

    private class_368.class_369 drawPlaque(class_332 graphics, long displayTime) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 instanceof class_433 || mc.field_1755 instanceof class_3928) {
            return class_368.class_369.field_2210;
        }
        class_185 displayInfo = this.toast.field_2205.comp_1920().comp_1913().orElse(null);
        class_4587 poseStack = graphics.method_51448();
        if (displayInfo != null) {
            float fadeOutTime;
            float fadeInTime;
            float duration = switch (displayInfo.method_815()) {
                default -> {
                    fadeInTime = (float)(AdvancementPlaquesConfig.getInstance().taskEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)(AdvancementPlaquesConfig.getInstance().taskEffectFadeOutTime.get() * 1000.0);
                    yield (float)(AdvancementPlaquesConfig.getInstance().taskDuration.get() * 1000.0);
                }
                case class_189.field_1249 -> {
                    fadeInTime = (float)(AdvancementPlaquesConfig.getInstance().goalEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)(AdvancementPlaquesConfig.getInstance().goalEffectFadeOutTime.get() * 1000.0);
                    yield (float)(AdvancementPlaquesConfig.getInstance().goalDuration.get() * 1000.0);
                }
                case class_189.field_1250 -> {
                    fadeInTime = (float)(AdvancementPlaquesConfig.getInstance().challengeEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)(AdvancementPlaquesConfig.getInstance().challengeEffectFadeOutTime.get() * 1000.0);
                    yield (float)(AdvancementPlaquesConfig.getInstance().challengeDuration.get() * 1000.0);
                }
            };
            graphics.method_51741(() -> {
                float alpha;
                if ((float)displayTime >= fadeInTime) {
                    alpha = 1.0f;
                    if ((float)displayTime > duration) {
                        alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                        if (Services.getPlatformHelper().isModLoaded("canvas")) {
                            alpha = 0.0f;
                        }
                    }
                    int titleColor = AdvancementPlaquesConfig.getInstance().getTitleColor(alpha).method_27716();
                    int nameColor = AdvancementPlaquesConfig.getInstance().getNameColor(alpha).method_27716();
                    RenderSystem.enableBlend();
                    graphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
                    RenderSystem.setShaderTexture((int)0, (class_2960)AdvancementPlaques.TEXTURE_PLAQUES);
                    int frameOffset = 0;
                    if (displayInfo.method_815() == class_189.field_1249) {
                        frameOffset = 1;
                    } else if (displayInfo.method_815() == class_189.field_1250) {
                        frameOffset = 2;
                    }
                    GuiHelper.blit((class_4587)poseStack, (int)-1, (int)-1, (int)this.width(), (int)this.height(), (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (int)256, (int)256);
                    if (alpha > 0.1f) {
                        int typeWidth = mc.field_1772.method_27525((class_5348)displayInfo.method_815().method_30756());
                        mc.field_1772.method_30882(displayInfo.method_815().method_30756(), (float)((int)((float)(this.width() - typeWidth) / 2.0f + 15.0f)), 5.0f, titleColor, false, poseStack.method_23760().method_23761(), (class_4597)graphics.method_51450(), class_327.class_6415.field_33994, 0, 0xF000F0);
                        graphics.method_51452();
                        int titleWidth = mc.field_1772.method_27525((class_5348)displayInfo.method_811());
                        if ((float)titleWidth <= 146.66667f) {
                            poseStack.method_22903();
                            poseStack.method_22905(1.5f, 1.5f, 1.0f);
                            mc.field_1772.method_30882(displayInfo.method_811(), (float)((int)(((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f)), 9.0f, nameColor, false, poseStack.method_23760().method_23761(), (class_4597)graphics.method_51450(), class_327.class_6415.field_33994, 0, 0xF000F0);
                            poseStack.method_22909();
                        } else {
                            mc.field_1772.method_30882(displayInfo.method_811(), (float)((int)((float)(this.width() - titleWidth) / 2.0f + 15.0f)), 15.0f, nameColor, false, poseStack.method_23760().method_23761(), (class_4597)graphics.method_51450(), class_327.class_6415.field_33994, 0, 0xF000F0);
                        }
                        graphics.method_51452();
                    }
                    poseStack.method_22903();
                    poseStack.method_46416(1.0f, 1.0f, 0.0f);
                    poseStack.method_22905(1.5f, 1.5f, 1.0f);
                    if (Services.getPlatformHelper().isModLoaded("canvas")) {
                        if (alpha > 0.0f) {
                            poseStack.method_46416(0.0f, 0.0f, -2000.0f);
                            graphics.method_51427(displayInfo.method_821(), 1, 1);
                        }
                    } else {
                        this.itemRenderer.renderItemModelIntoGUIWithAlpha(graphics, displayInfo.method_821(), 1, 1, alpha);
                    }
                    poseStack.method_22909();
                    if (!this.hasPlayedSound) {
                        this.hasPlayedSound = true;
                        try {
                            switch (displayInfo.method_815()) {
                                case field_1254: {
                                    if (AdvancementPlaquesConfig.getInstance().taskVolume.get() > 0.0) {
                                        mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)AdvancementPlaques.TASK_COMPLETE, (float)1.0f, (float)AdvancementPlaquesConfig.getInstance().taskVolume.get().floatValue()));
                                    }
                                    break;
                                }
                                case field_1249: {
                                    if (AdvancementPlaquesConfig.getInstance().goalVolume.get() > 0.0) {
                                        mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)AdvancementPlaques.GOAL_COMPLETE, (float)1.0f, (float)AdvancementPlaquesConfig.getInstance().goalVolume.get().floatValue()));
                                    }
                                    break;
                                }
                                default: {
                                    if (AdvancementPlaquesConfig.getInstance().challengeVolume.get() > 0.0) {
                                        mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15195, (float)1.0f, (float)AdvancementPlaquesConfig.getInstance().challengeVolume.get().floatValue()));
                                    }
                                    break;
                                }
                            }
                        }
                        catch (NullPointerException e) {
                            AdvancementPlaques.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered! Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                        }
                    }
                    if ((float)displayTime >= fadeInTime + fadeOutTime && alpha == 1.0f && !this.hasTakenScreenshot && Services.getPlatformHelper().isModLoaded("advancementscreenshot")) {
                        try {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.AdvancementScreenshotHandler").getMethod("takeScreenshot", new Class[0]).invoke(null, new Object[0]);
                            this.hasTakenScreenshot = true;
                        }
                        catch (Exception e) {
                            AdvancementPlaques.LOGGER.error((Object)e);
                        }
                    }
                }
                if ((float)displayTime < fadeInTime + fadeOutTime) {
                    alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                    if ((float)displayTime < fadeInTime) {
                        alpha = (float)displayTime / fadeInTime;
                    }
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    graphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
                    poseStack.method_22903();
                    poseStack.method_46416(0.0f, 0.0f, 95.0f);
                    RenderSystem.setShaderTexture((int)0, (class_2960)AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                    if (displayInfo.method_815() == class_189.field_1250) {
                        GuiHelper.blit((class_4587)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                    } else {
                        GuiHelper.blit((class_4587)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                    }
                    poseStack.method_22909();
                }
                graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            });
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
        }
        return class_368.class_369.field_2209;
    }

    public boolean render(int screenWidth, int index, class_332 graphics) {
        long currentTime = class_156.method_658();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
        }
        if (this.visibility == class_368.class_369.field_2210 && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        RenderSystem.disableDepthTest();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        if (AdvancementPlaquesConfig.getInstance().onTop.get().booleanValue()) {
            poseStack.method_46416((float)(graphics.method_51421() - this.width()) / 2.0f + (float)AdvancementPlaquesConfig.getInstance().horizontalOffset.get().intValue(), (float)AdvancementPlaquesConfig.getInstance().distance.get().intValue(), 800.0f + (float)index);
        } else {
            poseStack.method_46416((float)(graphics.method_51421() - this.width()) / 2.0f + (float)AdvancementPlaquesConfig.getInstance().horizontalOffset.get().intValue(), (float)(this.mc.method_22683().method_4502() - (this.height() + AdvancementPlaquesConfig.getInstance().distance.get())), 800.0f + (float)index);
        }
        class_368.class_369 newVisibility = this.drawPlaque(graphics, currentTime - this.visibleTime);
        poseStack.method_22909();
        RenderSystem.enableDepthTest();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == class_368.class_369.field_2209 && currentTime - this.animationTime > 200L;
    }
}

