/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.datagen;

import com.google.common.hash.HashCode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.pb4.polydecorations.block.furniture.TableBlock;
import eu.pb4.polydecorations.item.DecorationsItems;
import eu.pb4.polydecorations.ui.UiResourceCreator;
import eu.pb4.polydecorations.util.ResourceUtils;
import eu.pb4.polydecorations.util.WoodUtil;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_2405;
import net.minecraft.class_4719;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

class CustomAssetProvider
implements class_2405 {
    private final class_7784 output;
    private static final String BASE_WOOD_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"planks\": \"|PLANKS|\",\n    \"logs\": \"|LOG|\"\n  }\n}\n";
    private static final String MAILBOX_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"front\": \"|FRONT|\",\n    \"stripped_log\": \"|STRIPPED_LOG|\",\n    \"stripped_log_top\": \"|STRIPPED_LOG|_top\",\n    \"log\": \"|LOG|\",\n    \"log_top\": \"|LOG|_top\"\n  }\n}\n";
    private static final String MAILBOX_BAMBOO_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/base_|TYPE|\",\n  \"textures\": {\n    \"front\": \"|FRONT|\",\n    \"stripped_log\": \"|STRIPPED_LOG|\",\n    \"stripped_log_top\": \"|STRIPPED_LOG|\",\n    \"log\": \"|LOG|\",\n    \"log_top\": \"|LOG|_top\"\n  }\n}\n";
    private static final String STATUE_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/statue/stone/|TYPE|\",\n  \"textures\": {\n    \"0\": \"|TXT|\"\n  }\n}\n";
    private static final String STATUE_ITEM_JSON = "{\n  \"parent\": \"polydecorations:item/stone_statue\",\n  \"textures\": {\n    \"0\": \"|TXT|\"\n  }\n}\n";
    private static final String ITEM_MODEL_JSON = "{\n  \"parent\": \"polydecorations:block/|I|\"\n}\n";

    public CustomAssetProvider(FabricDataOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        BiConsumer<String, byte[]> assetWriter = (path, data) -> {
            try {
                writer.method_43346(this.output.method_45971().resolve((String)path), data, HashCode.fromBytes((byte[])data));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        return CompletableFuture.runAsync(() -> {
            try {
                this.createWoodPalettes(assetWriter);
                UiResourceCreator.generateAssets(assetWriter);
                this.writeBlocksAndItems(assetWriter);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, class_156.method_18349());
    }

    private void createWoodPalettes(BiConsumer<String, byte[]> assetWriter) throws Exception {
        Path jar = PolymerCommonUtils.getClientJarRoot();
        BufferedImage oakPlanks = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/oak_planks.png"), new OpenOption[0]));
        ArrayList<int[]> positions = new ArrayList<int[]>();
        IntOpenHashSet existingColors = new IntOpenHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                int rgb = oakPlanks.getRGB(x, y);
                if (!existingColors.add(rgb)) continue;
                positions.add(new int[]{x, y});
            }
        }
        BufferedImage palette = new BufferedImage(positions.size(), 1, 1);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        for (class_4719 wood : WoodUtil.VANILLA) {
            BufferedImage input = ImageIO.read(Files.newInputStream(jar.resolve("assets/minecraft/textures/block/" + wood.comp_1299() + "_planks.png"), new OpenOption[0]));
            for (int i = 0; i < positions.size(); ++i) {
                int[] pos = (int[])positions.get(i);
                palette.setRGB(i, 0, input.getRGB(pos[0], pos[1]));
            }
            ImageIO.write((RenderedImage)palette, "png", b);
            assetWriter.accept("assets/polydecorations/textures/palette/wood/" + wood.comp_1299() + ".png", b.toByteArray());
            b.reset();
        }
    }

    private void writeBlocksAndItems(BiConsumer<String, byte[]> writer) {
        StringBuilder t = new StringBuilder();
        DecorationsItems.SHELF.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_shelf.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "shelf").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_shelf_top.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "shelf_top").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_shelf_double.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "shelf_double").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/item/" + type.comp_1299() + "_shelf.json", ITEM_MODEL_JSON.replace("|I|", type.comp_1299() + "_shelf").getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.BENCH.forEach((type, item) -> {
            this.writeBench((class_4719)type, writer);
            writer.accept("assets/polydecorations/models/item/" + type.comp_1299() + "_bench.json", ITEM_MODEL_JSON.replace("|I|", type.comp_1299() + "_bench").getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.TABLE.forEach((type, block) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_table.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "table").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            for (int i = 1; i < TableBlock.TableModel.COUNT; ++i) {
                writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_table_" + i + ".json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "table_" + i).replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            }
            writer.accept("assets/polydecorations/models/item/" + type.comp_1299() + "_table.json", ITEM_MODEL_JSON.replace("|I|", type.comp_1299() + "_table").getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.WOODEN_STATUE.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_sign_post.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "sign_post").replace("|PLANKS|", "polydecorations:block/sign_post_" + type.comp_1299()).replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/item/" + type.comp_1299() + "_sign_post.json", ITEM_MODEL_JSON.replace("|I|", type.comp_1299() + "_sign_post").getBytes(StandardCharsets.UTF_8));
            this.writeStatue(type.comp_1299(), "block/" + type.comp_1299() + "_planks", writer);
        });
        DecorationsItems.WOODEN_MAILBOX.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_mailbox.json", (type != class_4719.field_40350 ? MAILBOX_MODEL_JSON : MAILBOX_BAMBOO_MODEL_JSON).replace("|TYPE|", "mailbox").replace("|FRONT|", "polydecorations:block/mailbox_front_" + type.comp_1299()).replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).replace("|STRIPPED_LOG|", "minecraft:block/stripped_" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/item/" + type.comp_1299() + "_mailbox.json", ITEM_MODEL_JSON.replace("|I|", type.comp_1299() + "_mailbox").getBytes(StandardCharsets.UTF_8));
        });
        DecorationsItems.TOOL_RACK.forEach((type, item) -> {
            writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_tool_rack.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "tool_rack").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
            writer.accept("assets/polydecorations/models/item/" + type.comp_1299() + "_tool_rack.json", ITEM_MODEL_JSON.replace("|I|", type.comp_1299() + "_tool_rack").getBytes(StandardCharsets.UTF_8));
        });
        this.writeBaseTable(writer);
        this.writeStatue("deepslate", "block/deepslate_top", writer);
        this.writeStatue("blackstone", "block/blackstone", writer);
        this.writeStatue("prismarine", "block/prismarine", writer);
        this.writeStatue("sandstone", "block/sandstone_top", writer);
        this.writeStatue("red_sandstone", "block/red_sandstone_top", writer);
        this.writeStatue("quartz", "block/quartz_block_bottom", writer);
        this.writeStatue("tuff", "block/tuff", writer);
        this.writeStatue("stone_bricks", "block/stone_bricks", writer);
        this.writeStatue("tuff_bricks", "block/tuff_bricks", writer);
        this.writeStatue("packed_mud", "block/packed_mud", writer);
        this.writeStatue("granite", "block/granite", writer);
        this.writeStatue("andesite", "block/andesite", writer);
        this.writeStatue("diorite", "block/diorite", writer);
        this.writeStatue("terracotta", "block/terracotta", writer);
        for (class_1767 color : class_1767.values()) {
            this.writeStatue(color.method_7792() + "_terracotta", "block/" + color.method_7792() + "_terracotta", writer);
        }
    }

    private void writeBaseTable(BiConsumer<String, byte[]> writer) {
        JsonElement json = JsonParser.parseString((String)new String(Objects.requireNonNull(ResourceUtils.getJarData("assets/polydecorations/models/block/base_table.json"))));
        for (int i = 1; i < TableBlock.TableModel.COUNT; ++i) {
            List<String> corners = TableBlock.TableModel.toCornerNames(i);
            JsonObject obj = json.deepCopy().getAsJsonObject();
            JsonArray newElements = new JsonArray();
            JsonArray elements = obj.getAsJsonArray("elements");
            for (JsonElement el : elements) {
                if (el.getAsJsonObject().has("name") && !corners.contains(el.getAsJsonObject().get("name").getAsString())) continue;
                newElements.add(el);
            }
            obj.add("elements", (JsonElement)newElements);
            writer.accept("assets/polydecorations/models/block/base_table_" + i + ".json", obj.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeBench(class_4719 name, BiConsumer<String, byte[]> writer) {
        this.writeBenchSet(name, "", writer);
        this.writeBenchSet(name, "_norest", writer);
    }

    private void writeBenchSet(class_4719 type, String suffix, BiConsumer<String, byte[]> writer) {
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + ".json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix).replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + "_left.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix + "_left").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + "_right.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix + "_right").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
        writer.accept("assets/polydecorations/models/block/" + type.comp_1299() + "_bench" + suffix + "_middle.json", BASE_WOOD_MODEL_JSON.replace("|TYPE|", "bench" + suffix + "_middle").replace("|PLANKS|", "minecraft:block/" + type.comp_1299() + "_planks").replace("|LOG|", "minecraft:block/" + WoodUtil.getLogName(type)).getBytes(StandardCharsets.UTF_8));
    }

    private void writeStatue(String type, String texture, BiConsumer<String, byte[]> writer) {
        for (String x : List.of("head", "body", "left_leg", "right_leg", "left_arm", "right_arm")) {
            writer.accept("assets/polydecorations/models/block/statue/" + type + "/" + x + ".json", STATUE_MODEL_JSON.replace("|TYPE|", x).replace("|TXT|", texture).getBytes(StandardCharsets.UTF_8));
        }
        writer.accept("assets/polydecorations/models/item/" + type + "_statue.json", STATUE_ITEM_JSON.replace("|TXT|", texture).getBytes(StandardCharsets.UTF_8));
    }

    public String method_10321() {
        return "polydecorations:assets";
    }
}

