/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polydecorations.entity.CanvasEntity;
import eu.pb4.polydecorations.item.CanvasItem;
import eu.pb4.polydecorations.recipe.DecorationsRecipeSerializers;
import eu.pb4.polymer.core.api.item.PolymerRecipe;
import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import org.jetbrains.annotations.Nullable;

public class CanvasTransformRecipe
extends class_1867
implements PolymerRecipe {
    private final class_1799 result;
    private final String action;
    private final class_1856 source;
    private final class_2371<class_1856> ingredientsOg;
    public static MapCodec<CanvasTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)Codec.STRING.optionalFieldOf("action", (Object)"wax").forGetter(CanvasTransformRecipe::action), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)class_1799.field_24671.fieldOf("result").forGetter(t -> t.result), (App)class_1856.field_46096.fieldOf("source").forGetter(t -> t.source), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
        Object[] ingredients2 = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
        return ingredients2.length > 8 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients2));
    }, DataResult::success).forGetter(t -> t.ingredientsOg)).apply((Applicative)instance, CanvasTransformRecipe::new));
    private final class_1860<?> vanilla;

    private String action() {
        return this.action;
    }

    public CanvasTransformRecipe(String group, String action, class_7710 category, class_1799 result, class_1856 source, class_2371<class_1856> ingredients) {
        super(group, category, result, CanvasTransformRecipe.merge(ingredients, source));
        this.ingredientsOg = ingredients;
        this.action = action;
        this.result = result;
        this.source = source;
        this.vanilla = new class_1867(group, category, result, this.method_8117());
    }

    private static class_2371<class_1856> merge(class_2371<class_1856> ingredients, class_1856 source) {
        class_2371 list = class_2371.method_10211();
        list.add((Object)source);
        list.addAll(ingredients);
        return list;
    }

    public class_1799 method_17729(class_9694 recipeInputInventory, class_7225.class_7874 wrapperLookup) {
        class_1799 stack = super.method_17729(recipeInputInventory, wrapperLookup);
        class_1799 dye = recipeInputInventory.method_59989().stream().filter(tmp -> tmp.method_31573(ConventionalItemTags.DYES)).findFirst().orElse(class_1799.field_8037);
        for (class_1799 tmp2 : recipeInputInventory.method_59989()) {
            if (!this.source.method_8093(tmp2)) continue;
            stack.method_57365(tmp2.method_57353());
            stack.method_57368(CanvasItem.DATA_TYPE, (Object)CanvasItem.Data.DEFAULT, x -> switch (this.action) {
                case "wax" -> new CanvasItem.Data(x.image(), x.background(), x.glowing(), true, x.cut());
                case "glow" -> new CanvasItem.Data(x.image(), x.background(), true, x.waxed(), x.cut());
                case "unglow" -> new CanvasItem.Data(x.image(), x.background(), false, x.waxed(), x.cut());
                case "dye" -> new CanvasItem.Data(x.image(), CanvasEntity.getColor(dye), x.glowing(), x.waxed(), x.cut());
                case "cut" -> {
                    byte[] image;
                    if (x.image().isPresent()) {
                        byte[] source = x.image().get();
                        image = new byte[source.length];
                        for (int i = 0; i < source.length; ++i) {
                            byte c = source[i];
                            if (c == 0) {
                                c = 1;
                            }
                            image[i] = c;
                        }
                    } else {
                        image = new byte[256];
                        Arrays.fill(image, (byte)1);
                    }
                    yield new CanvasItem.Data(Optional.ofNullable(image), x.background(), x.glowing(), x.waxed(), true);
                }
                case "uncut" -> {
                    byte[] image;
                    if (x.image().isPresent()) {
                        boolean isEmpty = true;
                        byte[] source = x.image().get();
                        image = new byte[source.length];
                        for (int i = 0; i < source.length; ++i) {
                            byte c = source[i];
                            if (c == 1) {
                                c = 0;
                            } else if (c != 0) {
                                isEmpty = false;
                            }
                            image[i] = c;
                        }
                        if (isEmpty) {
                            image = null;
                        }
                    } else {
                        image = null;
                    }
                    yield new CanvasItem.Data(Optional.ofNullable(image), x.background(), x.glowing(), x.waxed(), false);
                }
                default -> x;
            });
            break;
        }
        return stack;
    }

    public class_2371<class_1799> getRemainder(class_9694 input) {
        class_2371 defaultedList = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < defaultedList.size(); ++i) {
            class_1799 stack = input.method_59984(i);
            class_1799 remainer = stack.getRecipeRemainder();
            if (remainer.method_7960() && stack.method_7963()) {
                remainer = stack.method_7972();
                remainer.method_7974(remainer.method_7919() + 1);
                if (remainer.method_7919() >= remainer.method_7936()) {
                    remainer = class_1799.field_8037;
                }
            } else if (stack.method_31574(class_1802.field_8705)) {
                remainer = stack.method_7972();
            }
            defaultedList.set(i, (Object)remainer);
        }
        return defaultedList;
    }

    public class_1865<?> method_8119() {
        return DecorationsRecipeSerializers.CANVAS_TRANSFORM;
    }

    @Nullable
    public class_1860<?> getPolymerReplacement(class_3222 player) {
        return this.vanilla;
    }
}

