/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.polydecorations.ModInit;
import eu.pb4.polydecorations.util.DecorationsUtil;
import eu.pb4.polydecorations.util.ResourceUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class UiResourceCreator {
    public static final String BASE_MODEL = "minecraft:item/generated";
    public static final String X32_MODEL = "polydecorations:sgui/button_32";
    public static final String X32_RIGHT_MODEL = "polydecorations:sgui/button_32_right";
    private static final class_2583 STYLE = class_2583.field_24360.method_36139(0xFFFFFF).method_27704(DecorationsUtil.id("gui"));
    private static final String ITEM_TEMPLATE = "{\n  \"parent\": \"|BASE|\",\n  \"textures\": {\n    \"layer0\": \"|ID|\"\n  }\n}\n".replace(" ", "").replace("\n", "");
    private static final List<SlicedTexture> VERTICAL_PROGRESS = new ArrayList<SlicedTexture>();
    private static final List<SlicedTexture> HORIZONTAL_PROGRESS = new ArrayList<SlicedTexture>();
    private static final List<class_3545<PolymerModelData, String>> SIMPLE_MODEL = new ArrayList<class_3545<PolymerModelData, String>>();
    private static final Char2IntMap SPACES = new Char2IntOpenHashMap();
    private static final Char2ObjectMap<class_2960> TEXTURES = new Char2ObjectOpenHashMap();
    private static final Object2ObjectMap<class_3545<Character, Character>, class_2960> TEXTURES_POLYDEX = new Object2ObjectOpenHashMap();
    private static final List<String> TEXTURES_NUMBERS = new ArrayList<String>();
    private static char character;
    private static final char CHEST_SPACE0;
    private static final char CHEST_SPACE1;

    public static Supplier<GuiElementBuilder> icon16(String path) {
        PolymerModelData model = UiResourceCreator.genericIconRaw(class_1802.field_17500, path, BASE_MODEL);
        return () -> new GuiElementBuilder(model.item()).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip().setCustomModelData(model.value());
    }

    public static Supplier<GuiElementBuilder> icon32(String path) {
        PolymerModelData model = UiResourceCreator.genericIconRaw(class_1802.field_17500, path, X32_MODEL);
        return () -> new GuiElementBuilder(model.item()).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip().setCustomModelData(model.value());
    }

    public static IntFunction<GuiElementBuilder> icon32Color(String path) {
        PolymerModelData model = UiResourceCreator.genericIconRaw(class_1802.field_8570, path, X32_MODEL);
        return i -> {
            GuiElementBuilder b = new GuiElementBuilder(model.item()).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip().setCustomModelData(model.value());
            b.setComponent(class_9334.field_49644, (Object)new class_9282(i, false));
            return b;
        };
    }

    public static IntFunction<GuiElementBuilder> icon16(String path, int size) {
        PolymerModelData[] models = new PolymerModelData[size];
        for (int i2 = 0; i2 < size; ++i2) {
            models[i2] = UiResourceCreator.genericIconRaw(class_1802.field_17500, path + "_" + i2, BASE_MODEL);
        }
        return i -> new GuiElementBuilder(models[i].item()).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip().setCustomModelData(models[i].value());
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress16(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, BASE_MODEL, HORIZONTAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress32(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_MODEL, HORIZONTAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> horizontalProgress32Right(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_RIGHT_MODEL, HORIZONTAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress32(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_MODEL, VERTICAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress32Right(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, X32_RIGHT_MODEL, VERTICAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> verticalProgress16(String path, int start, int stop, boolean reverse) {
        return UiResourceCreator.genericProgress(path, start, stop, reverse, BASE_MODEL, VERTICAL_PROGRESS);
    }

    public static IntFunction<GuiElementBuilder> genericProgress(String path, int start, int stop, boolean reverse, String base, List<SlicedTexture> progressType) {
        PolymerModelData[] models = new PolymerModelData[stop - start];
        progressType.add(new SlicedTexture(path, start, stop, reverse));
        for (int i2 = start; i2 < stop; ++i2) {
            models[i2 - start] = UiResourceCreator.genericIconRaw(class_1802.field_17500, "gen/" + path + "_" + i2, base);
        }
        return i -> new GuiElementBuilder(models[i].item()).setName((class_2561)class_2561.method_43473()).hideDefaultTooltip().setCustomModelData(models[i].value());
    }

    public static PolymerModelData genericIconRaw(class_1792 item, String path, String base) {
        PolymerModelData model = PolymerResourcePackUtils.requestModel((class_1792)item, (class_2960)UiResourceCreator.elementPath(path));
        SIMPLE_MODEL.add((class_3545<PolymerModelData, String>)new class_3545((Object)model, (Object)base));
        return model;
    }

    private static class_2960 elementPath(String path) {
        return DecorationsUtil.id("sgui/elements/" + path);
    }

    public static Function<class_2561, class_2561> background(String path) {
        StringBuilder builder = new StringBuilder().append(CHEST_SPACE0);
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        builder.append(c2);
        builder.append(CHEST_SPACE1);
        TEXTURES.put(c2, (Object)DecorationsUtil.id("sgui/" + path));
        return new TextBuilders((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(STYLE));
    }

    public static class_3545<class_2561, class_2561> polydexBackground(String path) {
        char c = character;
        character = (char)(c + '\u0001');
        char c2 = c;
        char c3 = character;
        character = (char)(c3 + '\u0001');
        char d = c3;
        TEXTURES_POLYDEX.put((Object)new class_3545((Object)Character.valueOf(c2), (Object)Character.valueOf(d)), (Object)DecorationsUtil.id("sgui/polydex/" + path));
        return new class_3545((Object)class_2561.method_43470((String)Character.toString(c2)).method_10862(STYLE), (Object)class_2561.method_43470((String)Character.toString(d)).method_10862(STYLE));
    }

    public static void setup() {
        SPACES.put(CHEST_SPACE0, -8);
        SPACES.put(CHEST_SPACE1, -168);
        if (ModInit.DYNAMIC_ASSETS) {
            PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> UiResourceCreator.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
        }
    }

    private static void generateProgress(BiConsumer<String, byte[]> assetWriter, List<SlicedTexture> list, boolean horizontal) {
        for (SlicedTexture pair : list) {
            BufferedImage sourceImage = ResourceUtils.getTexture(UiResourceCreator.elementPath(pair.path()));
            BufferedImage image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
            int xw = horizontal ? image.getHeight() : image.getWidth();
            int mult = pair.reverse ? -1 : 1;
            int offset = pair.reverse ? pair.stop + pair.start - 1 : 0;
            for (int y = pair.start; y < pair.stop; ++y) {
                class_2960 path = UiResourceCreator.elementPath("gen/" + pair.path + "_" + y);
                int pos = offset + y * mult;
                for (int x = 0; x < xw; ++x) {
                    if (horizontal) {
                        image.setRGB(pos, x, sourceImage.getRGB(pos, x));
                        continue;
                    }
                    image.setRGB(x, pos, sourceImage.getRGB(x, pos));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                assetWriter.accept(AssetPaths.texture((String)path.method_12836(), (String)(path.method_12832() + ".png")), out.toByteArray());
            }
        }
    }

    public static void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        for (class_3545<PolymerModelData, String> texture : SIMPLE_MODEL) {
            assetWriter.accept("assets/" + ((PolymerModelData)texture.method_15442()).modelPath().method_12836() + "/models/" + ((PolymerModelData)texture.method_15442()).modelPath().method_12832() + ".json", ITEM_TEMPLATE.replace("|ID|", ((PolymerModelData)texture.method_15442()).modelPath().toString()).replace("|BASE|", (CharSequence)texture.method_15441()).getBytes(StandardCharsets.UTF_8));
        }
        UiResourceCreator.generateProgress(assetWriter, VERTICAL_PROGRESS, false);
        UiResourceCreator.generateProgress(assetWriter, HORIZONTAL_PROGRESS, true);
        JsonObject fontBase = new JsonObject();
        JsonArray providers = new JsonArray();
        JsonObject spaces = new JsonObject();
        spaces.addProperty("type", "space");
        JsonObject advances = new JsonObject();
        SPACES.char2IntEntrySet().stream().sorted(Comparator.comparing(Char2IntMap.Entry::getCharKey)).forEach(c -> advances.addProperty(Character.toString(c.getCharKey()), (Number)c.getIntValue()));
        spaces.add("advances", (JsonElement)advances);
        providers.add((JsonElement)spaces);
        TEXTURES.char2ObjectEntrySet().stream().sorted(Comparator.comparing(Char2ObjectMap.Entry::getCharKey)).forEach(entry -> {
            JsonObject bitmap = new JsonObject();
            bitmap.addProperty("type", "bitmap");
            bitmap.addProperty("file", ((class_2960)entry.getValue()).toString() + ".png");
            bitmap.addProperty("ascent", (Number)13);
            bitmap.addProperty("height", (Number)256);
            JsonArray chars = new JsonArray();
            chars.add(Character.toString(entry.getCharKey()));
            bitmap.add("chars", (JsonElement)chars);
            providers.add((JsonElement)bitmap);
        });
        TEXTURES_POLYDEX.entrySet().stream().sorted(Comparator.comparing(x -> (Character)((class_3545)x.getKey()).method_15442())).forEach(entry -> {
            JsonObject bitmap = new JsonObject();
            bitmap.addProperty("type", "bitmap");
            bitmap.addProperty("file", ((class_2960)entry.getValue()).toString() + ".png");
            bitmap.addProperty("ascent", (Number)-4);
            bitmap.addProperty("height", (Number)128);
            JsonArray chars = new JsonArray();
            chars.add(Character.toString(((Character)((class_3545)entry.getKey()).method_15442()).charValue()));
            chars.add(Character.toString(((Character)((class_3545)entry.getKey()).method_15441()).charValue()));
            bitmap.add("chars", (JsonElement)chars);
            providers.add((JsonElement)bitmap);
        });
        fontBase.add("providers", (JsonElement)providers);
        assetWriter.accept("assets/polydecorations/font/gui.json", fontBase.toString().getBytes(StandardCharsets.UTF_8));
    }

    static {
        char c = character = (char)97;
        character = (char)(c + '\u0001');
        CHEST_SPACE0 = c;
        char c2 = character;
        character = (char)(c2 + '\u0001');
        CHEST_SPACE1 = c2;
    }

    public record SlicedTexture(String path, int start, int stop, boolean reverse) {
    }

    private record TextBuilders(class_2561 base) implements Function<class_2561, class_2561>
    {
        @Override
        public class_2561 apply(class_2561 text) {
            return class_2561.method_43473().method_10852(this.base).method_10852(text);
        }
    }
}

