/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.compat;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import eu.pb4.graves.GravesApi;
import eu.pb4.graves.grave.GraveInventoryMask;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import net.minecraft.class_9701;

public record TrinketsCompat(boolean preventAddition) implements GraveInventoryMask
{
    private static final String GROUP_TAG = "Group";
    private static final String SLOT_TAG = "Slot";

    public static void register(boolean preventAddition) {
        GravesApi.registerInventoryMask(class_2960.method_60655((String)"universal_graves", (String)"trinkets"), new TrinketsCompat(preventAddition));
    }

    @Override
    public void addToGrave(class_3222 player, GraveInventoryMask.ItemConsumer consumer) {
        if (this.preventAddition) {
            return;
        }
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
            if (stack.method_7960() || !GravesApi.canAddItem(player, stack)) {
                return;
            }
            TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket((class_1792)stack.method_7909()).getDropRule(stack, ref, (class_1309)player);
            dropRule = ((TrinketDropCallback)TrinketDropCallback.EVENT.invoker()).drop(dropRule, stack, ref, (class_1309)player);
            TrinketInventory inventory = ref.inventory();
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = inventory.getSlotType().getDropRule();
            }
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655) ? TrinketEnums.DropRule.DESTROY : TrinketEnums.DropRule.DROP;
            }
            if (dropRule == TrinketEnums.DropRule.DROP) {
                class_2487 nbt = new class_2487();
                nbt.method_10582(GROUP_TAG, ref.inventory().getSlotType().getGroup());
                nbt.method_10582(SLOT_TAG, ref.inventory().getSlotType().getName());
                consumer.addItem(stack.method_7972(), ref.index(), (class_2520)nbt);
                inventory.method_5447(ref.index(), class_1799.field_8037);
            }
        }));
    }

    @Override
    public boolean moveToPlayerExactly(class_3222 player, class_1799 stack, int slot, class_2520 extraData) {
        String slotId;
        String groupId = ((class_2487)extraData).method_10558(GROUP_TAG);
        TrinketInventory inventory = this.getInventory(player, groupId, slotId = ((class_2487)extraData).method_10558(SLOT_TAG));
        if (inventory != null && inventory.method_5438(slot).method_7960()) {
            inventory.method_5447(slot, stack.method_51164());
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToPlayerClosest(class_3222 player, class_1799 stack, int slot, class_2520 data) {
        String slotId;
        String groupId = ((class_2487)data).method_10558(GROUP_TAG);
        TrinketInventory inventory = this.getInventory(player, groupId, slotId = ((class_2487)data).method_10558(SLOT_TAG));
        if (inventory != null) {
            int size = inventory.method_5439();
            for (int i = 0; i < size; ++i) {
                if (!inventory.method_5438(i).method_7960()) continue;
                inventory.method_5447(i, stack.method_51164());
                return true;
            }
        }
        return false;
    }

    private TrinketInventory getInventory(class_3222 player, String groupId, String slotId) {
        Map group;
        Optional optional = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optional.isPresent() && (group = (Map)((TrinketComponent)optional.get()).getInventory().get(groupId)) != null) {
            return (TrinketInventory)group.get(slotId);
        }
        return null;
    }
}

