/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.ui;

import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.other.GenericCost;
import eu.pb4.graves.other.GraveUtils;
import eu.pb4.graves.other.Location;
import eu.pb4.graves.other.OutputSlot;
import eu.pb4.graves.registry.GraveCompassItem;
import eu.pb4.graves.ui.GuiSlot;
import eu.pb4.graves.ui.PagedGui;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.Map;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class GraveGui
extends PagedGui {
    private final Grave grave;
    private final class_1263 inventory;
    private boolean canTake;
    private final boolean canFetch;
    private final GuiInterface previousUi;
    private final boolean canModify;
    private final boolean canTeleport;
    private final boolean hasAccess;
    private int ticker = 0;
    private int actionTimeRemoveProtect = -1;
    private int actionTimeFetch = -1;
    private int currentGraveSize;

    public GraveGui(class_3222 player, Grave grave, boolean canModify, boolean canFetch) {
        super(player);
        this.grave = grave;
        this.canModify = canModify;
        this.canTeleport = ConfigManager.getConfig().teleportation.cost.type() != GenericCost.Type.CREATIVE || player.method_7337();
        this.hasAccess = grave.hasAccess((class_1657)player);
        this.canTake = grave.canTakeFrom((class_1657)player);
        this.canFetch = canFetch;
        this.setTitle(ConfigManager.getConfig().ui.graveTitle.with(grave.getPlaceholders(player.method_37908().method_8503())));
        this.inventory = this.grave.asInventory();
        this.currentGraveSize = this.inventory.method_5439();
        this.previousUi = GuiHelpers.getCurrentGui((class_3222)player);
        this.updateDisplay();
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        return super.onAnyClick(index, type, action);
    }

    public void onTick() {
        if (this.grave.isRemoved()) {
            if (this.previousUi != null) {
                this.previousUi.open();
            } else {
                this.close();
            }
        }
        ++this.ticker;
        if (this.actionTimeRemoveProtect <= this.ticker) {
            this.actionTimeRemoveProtect = -1;
        }
        if (this.currentGraveSize != this.inventory.method_5439()) {
            this.currentGraveSize = this.inventory.method_5439();
            this.updateDisplay();
        } else if (this.ticker % 20 == 0) {
            if (this.canTake) {
                this.grave.tryBreak(this.player.method_5682(), (class_1657)this.player);
            }
            this.updateDisplay();
        }
        super.onTick();
    }

    public void onClose() {
        this.grave.updateDisplay();
        this.grave.updateSelf(this.player.method_5682());
        super.onClose();
    }

    @Override
    protected int getPageAmount() {
        return this.grave.getItems().size() / 36 + 1;
    }

    @Override
    protected GuiSlot getElement(int id) {
        if (id < this.inventory.method_5439()) {
            return GuiSlot.of(new OutputSlot(this.inventory, id, 0, 0, this.canModify && this.canTake));
        }
        return GuiSlot.empty();
    }

    @Override
    protected GuiSlot getNavElement(int id) {
        Config config = ConfigManager.getConfig();
        return switch (id) {
            case 0 -> {
                Map<String, class_2561> placeholders = this.grave.getPlaceholders(this.player.method_5682());
                yield GuiSlot.of(ConfigManager.getConfig().ui.graveInfoIcon.get(this.grave.isProtected()).builder(placeholders).setCallback((x, y, z) -> {
                    class_1799 cursor = this.player.field_7512.method_34255();
                    if (!cursor.method_7960() && cursor.method_31574(class_1802.field_8251)) {
                        cursor.method_7934(1);
                        this.player.method_31548().method_7398(GraveCompassItem.create(this.grave.getId(), true));
                    }
                }));
            }
            case 1 -> this.getUnlockGrave();
            case 2 -> this.getRemoveProtection();
            case 3 -> {
                if (this.canTake && this.canModify) {
                    yield GuiSlot.of(ConfigManager.getConfig().ui.quickPickupButton.builder().setCallback((x, y, z) -> {
                        GraveGui.playClickSound(this.player);
                        this.grave.quickEquip(this.player);
                    }));
                }
                if (this.canTeleport) {
                    yield GuiSlot.of(ConfigManager.getConfig().ui.teleportButton.get(config.teleportation.cost.checkCost(this.player)).builder(ConfigManager.getConfig().teleportation.cost.getPlaceholders()).setCallback((x, y, z) -> {
                        if (config.teleportation.cost.takeCost(this.player)) {
                            GraveGui.playClickSound(this.player);
                            this.close();
                            GraveUtils.teleportToGrave(this.player, this.grave, b -> {
                                if (!b) {
                                    config.teleportation.cost.returnCost(this.player);
                                }
                            });
                        } else {
                            GraveGui.playClickSound(this.player, class_3417.field_15008);
                        }
                    }));
                }
                yield GuiSlot.lowerBar(this.player);
            }
            case 4 -> {
                if (this.canFetch) {
                    yield GuiSlot.of(this.actionTimeFetch != -1 ? ConfigManager.getConfig().ui.fetchButton.get(false).builder().setCallback((x, y, z) -> {
                        GraveGui.playClickSound(this.player);
                        this.actionTimeFetch = -1;
                        if (!this.grave.moveTo(this.player.field_13995, Location.fromEntity(this.player))) {
                            return;
                        }
                        this.close();
                    }) : ConfigManager.getConfig().ui.fetchButton.get(true).builder().setCallback((x, y, z) -> {
                        GraveGui.playClickSound(this.player);
                        this.actionTimeFetch = this.ticker + 100;
                        this.updateDisplay();
                    }));
                }
                yield GuiSlot.lowerBar(this.player);
            }
            case 5 -> GuiSlot.previousPage(this);
            case 6 -> {
                if (this.previousUi != null) {
                    yield GuiSlot.nextPage(this);
                }
                yield GuiSlot.lowerBar(this.player);
            }
            case 7 -> {
                if (this.previousUi == null) {
                    yield GuiSlot.nextPage(this);
                }
                yield GuiSlot.lowerBar(this.player);
            }
            case 8 -> {
                if (this.previousUi != null) {
                    yield GuiSlot.back(() -> ((GuiInterface)this.previousUi).open());
                }
                yield GuiSlot.lowerBar(this.player);
            }
            default -> GuiSlot.lowerBar(this.player);
        };
    }

    private GuiSlot getUnlockGrave() {
        Config config = ConfigManager.getConfig();
        if (this.grave.isPaymentRequired() && (config.interactions.allowRemoteGraveUnlocking || Permissions.check((class_1297)this.player, (String)"graves.can_unlock_remotely", (int)3))) {
            return GuiSlot.of(ConfigManager.getConfig().ui.unlockButton.get(config.interactions.cost.checkCost(this.player)).builder(ConfigManager.getConfig().interactions.cost.getPlaceholders()).setCallback((x, y, z) -> {
                if (this.grave.payForUnlock(this.player)) {
                    this.canTake = this.grave.canTakeFrom((class_1657)this.player);
                    GraveGui.playClickSound(this.player);
                    this.updateDisplay();
                } else {
                    GraveGui.playClickSound(this.player, class_3417.field_15008);
                }
            }));
        }
        return GuiSlot.lowerBar(this.player);
    }

    private GuiSlot getRemoveProtection() {
        Config config = ConfigManager.getConfig();
        if (this.grave.isProtected() && this.hasAccess && (config.interactions.allowRemoteProtectionRemoval || Permissions.check((class_1297)this.player, (String)"graves.can_remove_protection_remotely", (int)3))) {
            if (this.actionTimeRemoveProtect != -1) {
                return GuiSlot.of(config.ui.removeProtectionButton.get(false).builder().setCallback((x, y, z) -> {
                    GraveGui.playClickSound(this.player);
                    this.grave.disableProtection();
                    this.actionTimeRemoveProtect = -1;
                    this.updateDisplay();
                }));
            }
            return GuiSlot.of(config.ui.removeProtectionButton.get(true).builder().setCallback((x, y, z) -> {
                GraveGui.playClickSound(this.player);
                this.actionTimeRemoveProtect = this.ticker + 100;
                this.updateDisplay();
            }));
        }
        if (this.canModify || this.canTake && (config.interactions.allowRemoteGraveBreaking || Permissions.check((class_1297)this.player, (String)"graves.can_break_remotely", (int)3))) {
            if (this.actionTimeRemoveProtect != -1) {
                return GuiSlot.of(config.ui.breakGraveButton.get(false).builder().setCallback((x, y, z) -> {
                    GraveGui.playClickSound(this.player);
                    this.grave.destroyGrave(this.player.method_5682(), (class_1657)this.player);
                    this.actionTimeRemoveProtect = -1;
                    this.close();
                }));
            }
            return GuiSlot.of(config.ui.breakGraveButton.get(true).builder().setCallback((x, y, z) -> {
                GraveGui.playClickSound(this.player);
                this.actionTimeRemoveProtect = this.ticker + 100;
                this.updateDisplay();
            }));
        }
        return GuiSlot.lowerBar(this.player);
    }
}

