/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.SolarPanelBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlock
extends class_2237 {
    public static final MapCodec<SolarPanelBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_41759.xmap(Tier::valueOf, Enum::toString).fieldOf("tier").forGetter(SolarPanelBlock::getTier)).apply((Applicative)instance, SolarPanelBlock::new));
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final Tier tier;

    public static class_2248 getBlockFromTier(Tier tier) {
        return switch (tier.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ModBlocks.SOLAR_PANEL_1;
            case 1 -> ModBlocks.SOLAR_PANEL_2;
            case 2 -> ModBlocks.SOLAR_PANEL_3;
            case 3 -> ModBlocks.SOLAR_PANEL_4;
            case 4 -> ModBlocks.SOLAR_PANEL_5;
            case 5 -> ModBlocks.SOLAR_PANEL_6;
        };
    }

    public SolarPanelBlock(Tier tier) {
        super(tier.getProperties());
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return SHAPE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 state) {
        return new SolarPanelBlockEntity(blockPos, state, this.tier);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 blockPos, class_2680 newState, boolean isMoving) {
        if (state.method_26204() == newState.method_26204()) {
            return;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof SolarPanelBlockEntity)) {
            return;
        }
        ((SolarPanelBlockEntity)blockEntity).drops(level, blockPos);
        super.method_9536(state, level, blockPos, newState, isMoving);
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof SolarPanelBlockEntity) || ((SolarPanelBlockEntity)blockEntity).getTier() != this.tier) {
            throw new IllegalStateException("Container is invalid");
        }
        player.method_17355((class_3908)((SolarPanelBlockEntity)blockEntity));
        return class_1269.field_5812;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return SolarPanelBlock.method_31618(type, SolarPanelBlockEntity.getEntityTypeFromTier(this.tier), SolarPanelBlockEntity::tick);
    }

    public static enum Tier {
        TIER_1("solar_panel_1", ModConfigs.COMMON_SOLAR_PANEL_1_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_1_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_1_CAPACITY.getValue(), class_4970.class_2251.method_9637().method_29292().method_9629(4.0f, 5.0f).method_9626(class_2498.field_11533)),
        TIER_2("solar_panel_2", ModConfigs.COMMON_SOLAR_PANEL_2_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_2_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_2_CAPACITY.getValue(), class_4970.class_2251.method_9637().method_29292().method_9629(4.0f, 5.0f).method_9626(class_2498.field_11533)),
        TIER_3("solar_panel_3", ModConfigs.COMMON_SOLAR_PANEL_3_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_3_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_3_CAPACITY.getValue(), class_4970.class_2251.method_9637().method_29292().method_9629(4.0f, 5.0f).method_9626(class_2498.field_11533)),
        TIER_4("solar_panel_4", ModConfigs.COMMON_SOLAR_PANEL_4_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_4_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_4_CAPACITY.getValue(), class_4970.class_2251.method_9637().method_29292().method_9629(4.0f, 5.0f).method_9626(class_2498.field_11533)),
        TIER_5("solar_panel_5", ModConfigs.COMMON_SOLAR_PANEL_5_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_5_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_5_CAPACITY.getValue(), class_4970.class_2251.method_9637().method_29292().method_9629(4.0f, 5.0f).method_9626(class_2498.field_11533)),
        TIER_6("solar_panel_6", ModConfigs.COMMON_SOLAR_PANEL_6_ENERGY_PEAK_PRODUCTION.getValue(), ModConfigs.COMMON_SOLAR_PANEL_6_TRANSFER_RATE.getValue(), ModConfigs.COMMON_SOLAR_PANEL_6_CAPACITY.getValue(), class_4970.class_2251.method_9637().method_29292().method_9629(4.0f, 5.0f).method_9626(class_2498.field_11533));

        private final String resourceId;
        private final long peakFePerTick;
        private final long maxTransfer;
        private final long capacity;
        private final class_4970.class_2251 props;

        private Tier(String resourceId, long peakFePerTick, long maxTransfer, long capacity, class_4970.class_2251 props) {
            this.resourceId = resourceId;
            this.peakFePerTick = peakFePerTick;
            this.maxTransfer = maxTransfer;
            this.capacity = capacity;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public long getPeakFePerTick() {
            return this.peakFePerTick;
        }

        public long getMaxTransfer() {
            return this.maxTransfer;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public class_4970.class_2251 getProperties() {
            return this.props;
        }
    }

    public static class Item
    extends class_1747 {
        private final Tier tier;

        public Item(class_2248 block, class_1792.class_1793 props, Tier tier) {
            super(block, props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.solar_panel.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getPeakFePerTick())}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.solar_panel.txt.shift.2").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
            }
        }
    }
}

