/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.AdvancedChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.screen.AdvancedChargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class AdvancedChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    final InputOutputItemHandler itemHandlerSided;
    private long[] energyConsumptionLeft;

    public AdvancedChargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_CHARGER_ENTITY, blockPos, blockState, "advanced_charger", ModConfigs.COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT.getValue() * 3L, ModConfigs.COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT.getValue() * 3L, 3, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i < 0 || i > 2) {
                return false;
            }
            class_1799 itemStack = this.itemHandler.method_5438(i.intValue());
            if (this.field_11863 != null && RecipeUtils.isResultOfAny(this.field_11863, ChargerRecipe.Type.INSTANCE, itemStack)) {
                return true;
            }
            if (this.field_11863 == null || RecipeUtils.isIngredientOfAny(this.field_11863, ChargerRecipe.Type.INSTANCE, itemStack)) {
                return false;
            }
            if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)) {
                return true;
            }
            EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get((int)i))));
            if (limitingEnergyStorage == null) {
                return true;
            }
            if (!limitingEnergyStorage.supportsInsertion()) {
                return true;
            }
            return limitingEnergyStorage.getAmount() == limitingEnergyStorage.getCapacity();
        });
        this.energyConsumptionLeft = new long[]{-1L, -1L, -1L};
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                AdvancedChargerBlockEntity.this.method_5431();
                AdvancedChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (AdvancedChargerBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(AdvancedChargerBlockEntity.this.field_11863, ChargerRecipe.Type.INSTANCE, stack)) {
                    return true;
                }
                if (slot >= 0 && slot < 3) {
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                        return false;
                    }
                    EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                    if (limitingEnergyStorage == null) {
                        return false;
                    }
                    return limitingEnergyStorage.supportsInsertion();
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || EnergyStorageUtil.isEnergyStorage((class_1799)stack) && EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)))) {
                        AdvancedChargerBlockEntity.this.resetProgress(slot);
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AdvancedChargerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1, 2, 3 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[0], index);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[1], index - 4);
                    case 8, 9, 10, 11 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[2], index - 8);
                    case 12 -> AdvancedChargerBlockEntity.this.redstoneMode.ordinal();
                    case 13 -> AdvancedChargerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 12: {
                        AdvancedChargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 13: {
                        AdvancedChargerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 14;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new AdvancedChargerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        for (int i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.energy_consumption_left." + i, (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft[i]));
        }
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        for (int i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.method_10537("recipe.energy_consumption_left." + i);
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedChargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AdvancedChargerBlock.POWERED))) {
            return;
        }
        long maxReceivePerSlot = (long)Math.min((double)blockEntity.limitingEnergyStorage.getMaxInsert() / 3.0, Math.ceil((double)((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                long energyConsumptionPerTick;
                class_1799 stack = blockEntity.itemHandler.method_5438(i);
                class_1277 inventory = new class_1277(1);
                inventory.method_5447(0, blockEntity.itemHandler.method_5438(i));
                Optional recipe = level.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_9695)new ContainerRecipeInputWrapper((class_1263)inventory), level);
                if (recipe.isPresent()) {
                    if (blockEntity.energyConsumptionLeft[i] == -1L) {
                        blockEntity.energyConsumptionLeft[i] = (long)((float)((ChargerRecipe)((class_8786)recipe.get()).comp_1933()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                    }
                    if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() == 0L) {
                        AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()));
                } else {
                    EnergyStorage limitingEnergyStorage;
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack) || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.itemHandler, null).getSlots().get(i))))) == null || !limitingEnergyStorage.supportsInsertion()) continue;
                    blockEntity.energyConsumptionLeft[i] = limitingEnergyStorage.getCapacity() - limitingEnergyStorage.getAmount();
                    if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() == 0L) {
                        AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    try (Transaction transaction = Transaction.openOuter();){
                        energyConsumptionPerTick = limitingEnergyStorage.insert(Math.min(maxReceivePerSlot, ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                        transaction.commit();
                    }
                }
                if (blockEntity.energyConsumptionLeft[i] < 0L || energyConsumptionPerTick < 0L) {
                    blockEntity.resetProgress(i);
                    AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    energyConsumptionPerTick = ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                int n = i;
                blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                if (blockEntity.energyConsumptionLeft[i] <= 0L) {
                    int index = i;
                    recipe.ifPresent(advancedChargerRecipe -> blockEntity.itemHandler.method_5447(index, ((ChargerRecipe)advancedChargerRecipe.comp_1933()).method_8110((class_7225.class_7874)level.method_30349()).method_46651(1)));
                    blockEntity.resetProgress(i);
                }
                AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(int index) {
        this.energyConsumptionLeft[index] = -1L;
    }

    private boolean hasRecipe(int index) {
        Optional recipe;
        class_1799 stack = this.itemHandler.method_5438(index);
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, this.itemHandler.method_5438(index));
        Optional optional = recipe = this.field_11863 == null ? Optional.empty() : this.field_11863.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_9695)new ContainerRecipeInputWrapper((class_1263)inventory), this.field_11863);
        if (recipe.isPresent()) {
            return true;
        }
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i);
        }
        super.updateUpgradeModules();
    }
}

