/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncFurnaceRecipeTypeS2CPacket;
import me.jddev0.ep.recipe.FurnaceRecipeTypePacketUpdate;
import me.jddev0.ep.screen.AdvancedPoweredFurnaceMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9696;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedPoweredFurnaceBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277>
implements FurnaceRecipeTypePacketUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    private static final long ENERGY_USAGE_PER_INPUT_PER_TICK = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_INPUT_PER_TICK.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    final InputOutputItemHandler itemHandlerSided;
    private int[] progress;
    private int[] maxProgress;
    private long[] energyConsumptionLeft;
    private boolean[] hasEnoughEnergy;
    @NotNull
    private class_3956<? extends class_1874> recipeType;

    public AdvancedPoweredFurnaceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_POWERED_FURNACE_ENTITY, blockPos, blockState, "advanced_powered_furnace", ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_TRANSFER_RATE.getValue(), 6, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.FURNACE_MODE);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i >= 0 && i < 3, i -> i >= 3 && i < 6);
        this.progress = new int[]{0, 0, 0};
        this.maxProgress = new int[]{0, 0, 0};
        this.energyConsumptionLeft = new long[]{-1L, -1L, -1L};
        this.hasEnoughEnergy = new boolean[]{false, false, false};
        this.recipeType = class_3956.field_17546;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * AdvancedPoweredFurnaceBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                AdvancedPoweredFurnaceBlockEntity.this.method_5431();
                AdvancedPoweredFurnaceBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * AdvancedPoweredFurnaceBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(AdvancedPoweredFurnaceBlockEntity.this.field_11863, AdvancedPoweredFurnaceBlockEntity.this.getRecipeForFurnaceModeUpgrade(), stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3, 4, 5 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(AdvancedPoweredFurnaceBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        AdvancedPoweredFurnaceBlockEntity.this.resetProgress(slot, AdvancedPoweredFurnaceBlockEntity.this.field_11867, AdvancedPoweredFurnaceBlockEntity.this.field_11863.method_8320(AdvancedPoweredFurnaceBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AdvancedPoweredFurnaceBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1, 2, 3 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[0], index);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[1], index - 4);
                    case 8, 9, 10, 11 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[2], index - 8);
                    case 12, 13 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[0], index - 12);
                    case 14, 15 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0], index - 14);
                    case 16, 17 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[1], index - 16);
                    case 18, 19 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1], index - 18);
                    case 20, 21 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[2], index - 20);
                    case 22, 23 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2], index - 22);
                    case 24 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[0]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 25 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[1]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 26 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[2]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 27 -> AdvancedPoweredFurnaceBlockEntity.this.redstoneMode.ordinal();
                    case 28 -> AdvancedPoweredFurnaceBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 12: 
                    case 13: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[0] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[0], (short)value, index - 12);
                        break;
                    }
                    case 14: 
                    case 15: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0], (short)value, index - 14);
                        break;
                    }
                    case 16: 
                    case 17: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[1] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[1], (short)value, index - 16);
                        break;
                    }
                    case 18: 
                    case 19: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1], (short)value, index - 18);
                        break;
                    }
                    case 20: 
                    case 21: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[2] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[2], (short)value, index - 20);
                        break;
                    }
                    case 22: 
                    case 23: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2], (short)value, index - 22);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: 
                    case 25: 
                    case 26: {
                        break;
                    }
                    case 27: {
                        AdvancedPoweredFurnaceBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 28: {
                        AdvancedPoweredFurnaceBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 29;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.method_11016()));
        return new AdvancedPoweredFurnaceMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        int i;
        super.method_11007(nbt, registries);
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.progress." + i, (class_2520)class_2497.method_23247((int)this.progress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.max_progress." + i, (class_2520)class_2497.method_23247((int)this.maxProgress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.energy_consumption_left." + i, (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft[i]));
        }
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        int i;
        super.method_11014(nbt, registries);
        for (i = 0; i < 3; ++i) {
            this.progress[i] = nbt.method_10550("recipe.progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.maxProgress[i] = nbt.method_10550("recipe.max_progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.method_10537("recipe.energy_consumption_left." + i);
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            return;
        }
        boolean hasNoRecipe = true;
        int hasNotEnoughEnergyCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (AdvancedPoweredFurnaceBlockEntity.hasRecipe(i, blockEntity)) {
                hasNoRecipe = false;
                class_1277 inventory = new class_1277(2);
                inventory.method_5447(0, blockEntity.itemHandler.method_5438(i));
                inventory.method_5447(1, blockEntity.itemHandler.method_5438(3 + i));
                Optional<? extends class_8786<? extends class_1874>> recipe = blockEntity.getRecipeFor((class_1263)inventory, level);
                if (recipe.isEmpty()) continue;
                int cookingTime = ((class_1874)recipe.get().comp_1933()).method_8167();
                if (blockEntity.maxProgress[i] == 0) {
                    blockEntity.maxProgress[i] = Math.max(1, (int)Math.ceil((double)((float)cookingTime * RECIPE_DURATION_MULTIPLIER / 6.0f) / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
                }
                long energyUsagePerInputPerTick = Math.max(1L, (long)Math.ceil((double)ENERGY_USAGE_PER_INPUT_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
                if (blockEntity.energyConsumptionLeft[i] < 0L) {
                    blockEntity.energyConsumptionLeft[i] = energyUsagePerInputPerTick * (long)blockEntity.maxProgress[i];
                }
                if (energyUsagePerInputPerTick <= ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                    blockEntity.hasEnoughEnergy[i] = true;
                    if (level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && !((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                        level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
                    }
                    if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0L) {
                        blockEntity.resetProgress(i, blockPos, state);
                        AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    try (Transaction transaction = Transaction.openOuter();){
                        ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyUsagePerInputPerTick, (TransactionContext)transaction);
                        transaction.commit();
                    }
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyUsagePerInputPerTick;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        AdvancedPoweredFurnaceBlockEntity.craftItem(i, blockPos, state, blockEntity);
                    }
                    AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                ++hasNotEnoughEnergyCount;
                AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i, blockPos, state);
            ++hasNotEnoughEnergyCount;
            AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        if ((hasNoRecipe || hasNotEnoughEnergyCount == 3) && level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && ((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void resetProgress(int index, class_2338 blockPos, class_2680 state) {
        this.progress[index] = 0;
        this.maxProgress[index] = 0;
        this.energyConsumptionLeft[index] = -1L;
        this.hasEnoughEnergy[index] = false;
    }

    private static void craftItem(int index, class_2338 blockPos, class_2680 state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        class_1277 inventory = new class_1277(2);
        inventory.method_5447(0, blockEntity.itemHandler.method_5438(index));
        inventory.method_5447(1, blockEntity.itemHandler.method_5438(3 + index));
        Optional<? extends class_8786<? extends class_1874>> recipe = blockEntity.getRecipeFor((class_1263)inventory, level);
        if (!AdvancedPoweredFurnaceBlockEntity.hasRecipe(index, blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.method_5434(index, 1);
        blockEntity.itemHandler.method_5447(3 + index, ((class_1874)recipe.get().comp_1933()).method_8110((class_7225.class_7874)level.method_30349()).method_46651(blockEntity.itemHandler.method_5438(3 + index).method_7947() + ((class_1874)recipe.get().comp_1933()).method_8110((class_7225.class_7874)level.method_30349()).method_7947()));
        blockEntity.resetProgress(index, blockPos, state);
    }

    private static boolean hasRecipe(int index, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        class_1277 inventory = new class_1277(2);
        inventory.method_5447(0, blockEntity.itemHandler.method_5438(index));
        inventory.method_5447(1, blockEntity.itemHandler.method_5438(3 + index));
        Optional<? extends class_8786<? extends class_1874>> recipe = blockEntity.getRecipeFor((class_1263)inventory, level);
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((class_1263)blockEntity.itemHandler, 3 + index, ((class_1874)recipe.get().comp_1933()).method_8110((class_7225.class_7874)level.method_30349()));
    }

    private Optional<? extends class_8786<? extends class_1874>> getRecipeFor(class_1263 container, class_1937 level) {
        return level.method_8433().method_30027(this.getRecipeForFurnaceModeUpgrade()).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.comp_1932())).filter(recipe -> ((class_1874)recipe.comp_1933()).method_59981(new class_9696(container.method_5438(0)), level)).findFirst();
    }

    public class_3956<? extends class_1874> getRecipeForFurnaceModeUpgrade() {
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return this.recipeType;
        }
        double value = this.upgradeModuleInventory.getUpgradeModuleModifierEffect(3, UpgradeModuleModifier.FURNACE_MODE);
        if (value == 1.0) {
            return class_3956.field_17547;
        }
        if (value == 2.0) {
            return class_3956.field_17548;
        }
        return class_3956.field_17546;
    }

    @Override
    public void setRecipeType(class_3956<? extends class_1874> recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i, this.method_11016(), this.method_11010());
        }
        super.updateUpgradeModules();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, 32.0, new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.method_11016()));
        }
    }
}

