/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.ModRecipes;
import me.jddev0.ep.screen.AlloyFurnaceMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceBlockEntity
extends MenuInventoryStorageBlockEntity<class_1277> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ALLOY_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private int progress;
    private int maxProgress;
    private int litDuration;
    private int maxLitDuration;
    private final Predicate<Integer> canOutput = i -> {
        if (i == 3) {
            class_1799 item = this.itemHandler.method_5438(i.intValue());
            Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
            return burnTime == null || burnTime <= 0;
        }
        return i > 3 && i < 6;
    };
    private final InputOutputItemHandler itemHandlerSidedTopBottom = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 3, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedFront = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i >= 0 && i < 3, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedBack = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 1, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedLeft = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, this.canOutput);
    private final InputOutputItemHandler itemHandlerSidedRight = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 2, this.canOutput);

    public AlloyFurnaceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ALLOY_FURNACE_ENTITY, blockPos, blockState, "alloy_furnace", 6);
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AlloyFurnaceBlockEntity.this.field_11863 == null || AlloyFurnaceBlockEntity.this.field_11863.method_8433().method_30027((class_3956)AlloyFurnaceRecipe.Type.INSTANCE).stream().map(class_8786::comp_1933).map(AlloyFurnaceRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(AlloyFurnaceRecipe.IngredientWithCount::input).anyMatch(ingredient -> ingredient.method_8093(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
                        if (burnTime != null && burnTime > 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4, 5 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        AlloyFurnaceBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AlloyFurnaceBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.litDuration, index - 4);
                    case 6, 7 -> ByteUtils.get2Bytes(AlloyFurnaceBlockEntity.this.maxLitDuration, index - 6);
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AlloyFurnaceBlockEntity.this.progress = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AlloyFurnaceBlockEntity.this.maxProgress = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: {
                        AlloyFurnaceBlockEntity.this.litDuration = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.litDuration, (short)value, index - 4);
                        break;
                    }
                    case 6: 
                    case 7: {
                        AlloyFurnaceBlockEntity.this.maxLitDuration = ByteUtils.with2Bytes(AlloyFurnaceBlockEntity.this.maxLitDuration, (short)value, index - 6);
                    }
                }
            }

            public int method_17389() {
                return 8;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new AlloyFurnaceMenu(id, this, inventory, (class_1263)this.itemHandler, this.data);
    }

    public int getRedstoneOutput() {
        return class_1703.method_7618((class_1263)this.itemHandler);
    }

    public Storage<ItemVariant> getInventoryStorageForDirection(class_2350 side) {
        if (side == null) {
            return null;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)AssemblingMachineBlock.FACING);
        if (facing == side) {
            return this.itemHandlerSidedFront.apply(side);
        }
        if (facing.method_10153() == side) {
            return this.itemHandlerSidedBack.apply(side);
        }
        if (facing.method_10170() == side) {
            return this.itemHandlerSidedLeft.apply(side);
        }
        if (facing.method_10160() == side) {
            return this.itemHandlerSidedRight.apply(side);
        }
        return this.itemHandlerSidedTopBottom.apply(side);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.max_progress", (class_2520)class_2497.method_23247((int)this.maxProgress));
        nbt.method_10566("recipe.lit_duration", (class_2520)class_2497.method_23247((int)this.litDuration));
        nbt.method_10566("recipe.max_lit_duration", (class_2520)class_2497.method_23247((int)this.maxLitDuration));
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.progress = nbt.method_10550("recipe.progress");
        this.maxProgress = nbt.method_10550("recipe.max_progress");
        this.litDuration = nbt.method_10550("recipe.lit_duration");
        this.maxLitDuration = nbt.method_10550("recipe.max_lit_duration");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AlloyFurnaceBlockEntity blockEntity) {
        if (level.field_9236) {
            return;
        }
        boolean hasNotEnoughFuel = false;
        if (blockEntity.litDuration > 0) {
            --blockEntity.litDuration;
            if (blockEntity.litDuration <= 0) {
                blockEntity.maxLitDuration = 0;
                hasNotEnoughFuel = true;
            }
            AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        if (blockEntity.hasRecipe()) {
            Optional<class_8786<AlloyFurnaceRecipe>> recipe = blockEntity.getCurrentRecipe();
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.litDuration <= 0) {
                class_1799 item = blockEntity.itemHandler.method_5438(3);
                Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
                blockEntity.maxLitDuration = burnTime == null ? 0 : burnTime;
                blockEntity.litDuration = blockEntity.maxLitDuration;
                if (blockEntity.maxLitDuration > 0) {
                    blockEntity.onHasEnoughFuel();
                    hasNotEnoughFuel = false;
                    if (!item.getRecipeRemainder().method_7960()) {
                        blockEntity.itemHandler.method_5447(3, item.getRecipeRemainder());
                    } else {
                        blockEntity.itemHandler.method_5434(3, 1);
                    }
                }
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)((float)((AlloyFurnaceRecipe)recipe.get().comp_1933()).getTicks() * RECIPE_DURATION_MULTIPLIER));
            }
            if (blockEntity.litDuration > 0) {
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                    if (hasNotEnoughFuel) {
                        blockEntity.onHasNotEnoughFuel();
                    }
                    blockEntity.resetProgress();
                    AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem(recipe.get());
                }
                AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.progress = Math.max(blockEntity.progress - 2, 0);
                hasNotEnoughFuel = true;
                AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress();
            AlloyFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        if (hasNotEnoughFuel) {
            blockEntity.onHasNotEnoughFuel();
        }
    }

    private void onHasEnoughFuel() {
        if (this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12548) && !((Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void onHasNotEnoughFuel() {
        if (this.field_11863.method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12548) && ((Boolean)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private class_9695 getRecipeInput(class_1263 inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    private Optional<class_8786<AlloyFurnaceRecipe>> getRecipeFor(class_1277 inventory) {
        return this.field_11863.method_8433().method_8132(ModRecipes.ALLOY_FURNACE_TYPE, this.getRecipeInput((class_1263)inventory), this.field_11863);
    }

    private Optional<class_8786<AlloyFurnaceRecipe>> getCurrentRecipe() {
        return this.getRecipeFor(this.itemHandler);
    }

    private boolean hasRecipe() {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<class_8786<AlloyFurnaceRecipe>> recipe = this.getRecipeFor(this.itemHandler);
        return recipe.isPresent() && this.canCraftRecipe(this.itemHandler, recipe.get());
    }

    protected void craftItem(class_8786<AlloyFurnaceRecipe> recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        AlloyFurnaceRecipe.IngredientWithCount[] inputs = ((AlloyFurnaceRecipe)recipe.comp_1933()).getInputs();
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = this.itemHandler.method_5438(i).method_7960();
        }
        int len = Math.min(inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            AlloyFurnaceRecipe.IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                class_1799 item = this.itemHandler.method_5438(j);
                if (indexMinCount != -1 && item.method_7947() >= minCount || !input.input().method_8093(item) || item.method_7947() < input.count()) continue;
                indexMinCount = j;
                minCount = item.method_7947();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.method_5434(indexMinCount, input.count());
        }
        class_1799[] outputs = ((AlloyFurnaceRecipe)recipe.comp_1933()).generateOutputs(this.field_11863.field_9229);
        this.itemHandler.method_5447(4, outputs[0].method_46651(this.itemHandler.method_5438(4).method_7947() + outputs[0].method_7947()));
        if (!outputs[1].method_7960()) {
            this.itemHandler.method_5447(5, outputs[1].method_46651(this.itemHandler.method_5438(5).method_7947() + outputs[1].method_7947()));
        }
        this.resetProgress();
    }

    private boolean canCraftRecipe(class_1277 inventory, class_8786<AlloyFurnaceRecipe> recipe) {
        class_1799[] maxOutputs = ((AlloyFurnaceRecipe)recipe.comp_1933()).getMaxOutputCounts();
        return this.field_11863 != null && InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 4, maxOutputs[0]) && (maxOutputs[1].method_7960() || InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 5, maxOutputs[1]));
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
    }
}

