/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.jddev0.ep.block.AutoCrafterBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AutoCrafterMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.ItemStackUtils;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCrafterBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277>
implements CheckboxUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    public static final long ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue();
    public static final int RECIPE_DURATION = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private boolean secondaryExtractMode;
    final InputOutputItemHandler itemHandlerSided;
    private final class_1277 patternSlots;
    private final class_1277 patternResultSlots;
    private final class_1265 updatePatternListener;
    private boolean hasRecipeLoaded;
    private class_2960 recipeIdForSetRecipe;
    private class_8786<class_3955> craftingRecipe;
    private class_1715 oldCopyOfRecipe;
    private final class_1703 dummyContainerMenu;
    private int progress;
    private int maxProgress;
    private long energyConsumptionLeft;
    private boolean hasEnoughEnergy;
    private boolean ignoreNBT;

    public AutoCrafterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.AUTO_CRAFTER_ENTITY, blockPos, blockState, "auto_crafter", ModConfigs.COMMON_AUTO_CRAFTER_CAPACITY.getValue(), ModConfigs.COMMON_AUTO_CRAFTER_TRANSFER_RATE.getValue(), 18, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i >= 3, i -> this.secondaryExtractMode ? !this.isInput(this.itemHandler.method_5438(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.itemHandler.method_5438(i.intValue())));
        this.patternSlots = new class_1277(this, 9){

            public int method_5444() {
                return 1;
            }
        };
        this.patternResultSlots = new class_1277(1);
        this.updatePatternListener = container -> this.updateRecipe();
        this.hasRecipeLoaded = false;
        this.dummyContainerMenu = new class_1703(this, null, -1){

            public class_1799 method_7601(class_1657 player, int index) {
                return null;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }

            public void method_7609(class_1263 container) {
            }
        };
        this.energyConsumptionLeft = -1L;
        this.patternSlots.method_5489(this.updatePatternListener);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * AutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                AutoCrafterBlockEntity.this.method_5431();
                AutoCrafterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * AutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot < 0 || slot >= 18) {
                    return super.method_5437(slot, stack);
                }
                return slot >= 3;
            }

            public void method_5431() {
                super.method_5431();
                AutoCrafterBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (AutoCrafterBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> {
                        if (AutoCrafterBlockEntity.this.ignoreNBT) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 10 -> {
                        if (AutoCrafterBlockEntity.this.secondaryExtractMode) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 11 -> AutoCrafterBlockEntity.this.redstoneMode.ordinal();
                    case 12 -> AutoCrafterBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AutoCrafterBlockEntity.this.progress = ByteUtils.with2Bytes(AutoCrafterBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AutoCrafterBlockEntity.this.maxProgress = ByteUtils.with2Bytes(AutoCrafterBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        AutoCrafterBlockEntity.this.ignoreNBT = value != 0;
                        break;
                    }
                    case 10: {
                        AutoCrafterBlockEntity.this.secondaryExtractMode = value != 0;
                        break;
                    }
                    case 11: {
                        AutoCrafterBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 12: {
                        AutoCrafterBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 13;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new AutoCrafterMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, (class_1263)this.patternSlots, (class_1263)this.patternResultSlots, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10566("pattern", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.patternSlots.field_5828, (class_7225.class_7874)registries));
        if (this.craftingRecipe != null) {
            nbt.method_10566("recipe.id", (class_2520)class_2519.method_23256((String)this.craftingRecipe.comp_1932().toString()));
        }
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.max_progress", (class_2520)class_2497.method_23247((int)this.maxProgress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
        nbt.method_10556("ignore_nbt", this.ignoreNBT);
        nbt.method_10556("secondary_extract_mode", this.secondaryExtractMode);
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        class_1262.method_5429((class_2487)nbt.method_10562("pattern"), (class_2371)this.patternSlots.field_5828, (class_7225.class_7874)registries);
        if (nbt.method_10545("recipe.id")) {
            class_2520 tag = nbt.method_10580("recipe.id");
            if (!(tag instanceof class_2519)) {
                throw new IllegalArgumentException("Tag must be of type StringTag!");
            }
            class_2519 stringTag = (class_2519)tag;
            this.recipeIdForSetRecipe = class_2960.method_12829((String)stringTag.method_10714());
        }
        this.progress = nbt.method_10550("recipe.progress");
        this.maxProgress = nbt.method_10550("recipe.max_progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
        this.ignoreNBT = nbt.method_10577("ignore_nbt");
        this.secondaryExtractMode = nbt.method_10577("secondary_extract_mode");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AutoCrafterBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.hasRecipeLoaded) {
            blockEntity.updateRecipe();
            if (blockEntity.craftingRecipe == null) {
                blockEntity.resetProgress();
            }
            AutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AutoCrafterBlock.POWERED))) {
            return;
        }
        int itemCount = 0;
        for (int i = 0; i < blockEntity.patternSlots.method_5439(); ++i) {
            if (blockEntity.patternSlots.method_5438(i).method_7960()) continue;
            ++itemCount;
        }
        if (itemCount == 0) {
            return;
        }
        if (blockEntity.craftingRecipe != null && (blockEntity.progress > 0 || blockEntity.canInsertIntoOutputSlots() && blockEntity.canExtractItemsFromInput())) {
            if (!blockEntity.canInsertIntoOutputSlots() || !blockEntity.canExtractItemsFromInput()) {
                return;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)Math.ceil((double)RECIPE_DURATION / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
            }
            long energyConsumptionPerTick = Math.max(1L, (long)Math.ceil((double)((long)itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (blockEntity.progress == 0) {
                if (!blockEntity.canExtractItemsFromInput()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * (long)blockEntity.maxProgress;
            }
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.resetProgress();
                AutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                return;
            }
            if (energyConsumptionPerTick <= ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                try (Transaction transaction = Transaction.openOuter();){
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    class_1277 patternSlotsForRecipe = blockEntity.ignoreNBT ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots) : blockEntity.patternSlots;
                    class_1715 copyOfPatternSlots = new class_1715(blockEntity.dummyContainerMenu, 3, 3);
                    for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
                        copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
                    }
                    blockEntity.extractItems();
                    blockEntity.craftItem(copyOfPatternSlots);
                }
                AutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                AutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress();
            AutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = true;
    }

    public void resetProgressAndMarkAsChanged() {
        this.resetProgress();
        AutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void cycleRecipe() {
        class_1277 patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        List<class_8786<class_3955>> recipes = this.getRecipesFor(copyOfPatternSlots, this.field_11863);
        if (recipes.isEmpty()) {
            this.updateRecipe();
            return;
        }
        if (this.recipeIdForSetRecipe == null) {
            this.recipeIdForSetRecipe = this.craftingRecipe == null || this.craftingRecipe.comp_1932() == null ? recipes.get(0).comp_1932() : this.craftingRecipe.comp_1932();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).comp_1932(), this.recipeIdForSetRecipe)) continue;
            this.recipeIdForSetRecipe = recipes.get((i + 1) % recipes.size()).comp_1932();
            break;
        }
        this.updateRecipe();
    }

    public void setRecipeIdForSetRecipe(class_2960 recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe = recipeIdForSetRecipe;
        this.updateRecipe();
    }

    private void updateRecipe() {
        if (this.field_11863 == null) {
            return;
        }
        class_8786<class_3955> oldRecipe = null;
        class_1799 oldResult = null;
        if (this.hasRecipeLoaded && this.craftingRecipe != null && this.oldCopyOfRecipe != null) {
            oldRecipe = this.craftingRecipe;
            oldResult = this.craftingRecipe.comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe.comp_1933()).method_8116((class_9695)this.oldCopyOfRecipe.method_59961(), (class_7225.class_7874)this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe.comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349());
        }
        this.hasRecipeLoaded = true;
        class_1277 patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        Optional<Pair<class_2960, class_8786<class_3955>>> recipe = this.getRecipeFor(copyOfPatternSlots, this.field_11863, this.recipeIdForSetRecipe);
        if (recipe.isPresent()) {
            this.craftingRecipe = (class_8786)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe != null && !Objects.equals(this.craftingRecipe.comp_1932(), this.recipeIdForSetRecipe)) {
                this.recipeIdForSetRecipe = this.craftingRecipe.comp_1932();
                this.resetProgress();
            }
            class_1799 resultItemStack = this.craftingRecipe.comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe.comp_1933()).method_8116((class_9695)copyOfPatternSlots.method_59961(), (class_7225.class_7874)this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe.comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349());
            this.patternResultSlots.method_5447(0, resultItemStack);
            if (oldRecipe != null && oldResult != null && this.oldCopyOfRecipe != null && (this.craftingRecipe != oldRecipe || class_1799.method_31577((class_1799)resultItemStack, (class_1799)oldResult))) {
                this.resetProgress();
            }
            this.oldCopyOfRecipe = new class_1715(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
                this.oldCopyOfRecipe.method_5447(i, copyOfPatternSlots.method_5438(i).method_7972());
            }
        } else {
            this.recipeIdForSetRecipe = null;
            this.craftingRecipe = null;
            this.patternResultSlots.method_5447(0, class_1799.field_8037);
            this.oldCopyOfRecipe = null;
            this.resetProgress();
        }
    }

    private void extractItems() {
        class_1277 patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<class_1799> patternItemStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            if (patternSlotsForRecipe.method_5438(i).method_7960()) continue;
            patternItemStacks.add(patternSlotsForRecipe.method_5438(i));
        }
        List<class_1799> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (class_1799 itemStack : itemStacksExtract) {
            for (int i = 0; i < this.itemHandler.method_5439(); ++i) {
                class_1799 ret;
                class_1799 testItemStack = this.itemHandler.method_5438(i);
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (ret = this.itemHandler.method_5434(i, itemStack.method_7947())).method_7960()) continue;
                int amount = ret.method_7947();
                if (amount == itemStack.method_7947()) continue block1;
                itemStack.method_7934(amount);
            }
        }
    }

    private void craftItem(class_1715 copyOfPatternSlots) {
        if (this.craftingRecipe == null) {
            this.resetProgress();
            return;
        }
        ArrayList<class_1799> outputItemStacks = new ArrayList<class_1799>(10);
        class_1799 resultItemStack = this.craftingRecipe.comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe.comp_1933()).method_8116((class_9695)copyOfPatternSlots.method_59961(), (class_7225.class_7874)this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe.comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349());
        outputItemStacks.add(resultItemStack);
        for (class_1799 remainingItem : ((class_3955)this.craftingRecipe.comp_1933()).method_8111((class_9695)copyOfPatternSlots.method_59961())) {
            if (remainingItem.method_7960()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<class_1799> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(18);
        block1: for (class_1799 itemStack : itemStacksInsert) {
            for (int i = 0; i < this.itemHandler.method_5439(); ++i) {
                int amount;
                class_1799 testItemStack = this.itemHandler.method_5438(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.method_7960()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947())) <= 0) continue;
                this.itemHandler.method_5447(i, this.itemHandler.method_5438(i).method_46651(testItemStack.method_7947() + amount));
                itemStack.method_7939(itemStack.method_7947() - amount);
                if (itemStack.method_7960()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.method_5447(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT) {
            this.updateRecipe();
        }
        this.resetProgress();
    }

    private boolean canExtractItemsFromInput() {
        if (this.craftingRecipe == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<class_1799> patternItemStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            if (patternSlotsForRecipe.method_5438(i).method_7960()) continue;
            patternItemStacks.add(patternSlotsForRecipe.method_5438(i));
        }
        List<class_1799> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                class_1799 itemStack = itemStacks.get(i);
                for (int j = 0; j < this.itemHandler.method_5439(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    class_1799 testItemStack = this.itemHandler.method_5438(j);
                    if (testItemStack.method_7960()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                    int amount = Math.min(itemStack.method_7947(), testItemStack.method_7947());
                    checkedIndices.add(j);
                    if (amount != itemStack.method_7947()) {
                        itemStack.method_7934(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertIntoOutputSlots() {
        class_1799 resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        ArrayList<class_1799> outputItemStacks = new ArrayList<class_1799>(10);
        class_1799 class_17992 = resultItemStack = this.craftingRecipe.comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe.comp_1933()).method_8116((class_9695)copyOfPatternSlots.method_59961(), (class_7225.class_7874)this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe.comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349());
        if (!resultItemStack.method_7960()) {
            outputItemStacks.add(resultItemStack);
        }
        for (class_1799 remainingItem : ((class_3955)this.craftingRecipe.comp_1933()).method_8111((class_9695)copyOfPatternSlots.method_59961())) {
            if (remainingItem.method_7960()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<class_1799> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(18);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            class_1799 itemStack = itemStacks.get(i);
            for (int j = 0; j < this.itemHandler.method_5439(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                class_1799 testItemStack = this.itemHandler.method_5438(j);
                if (testItemStack.method_7960()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                int amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947());
                if (amount + testItemStack.method_7947() == testItemStack.method_7914()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.method_7947()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack.method_7934(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack.method_7947() == itemStack.method_7914()) {
                checkedIndices.add(index);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(class_1799 itemStack) {
        class_1799 resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        class_1799 class_17992 = resultItemStack = this.craftingRecipe.comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe.comp_1933()).method_8116((class_9695)copyOfPatternSlots.method_59961(), (class_7225.class_7874)this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe.comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349());
        if (class_1799.method_7984((class_1799)itemStack, (class_1799)resultItemStack) && class_1799.method_31577((class_1799)itemStack, (class_1799)resultItemStack)) {
            return true;
        }
        for (class_1799 remainingItem : ((class_3955)this.craftingRecipe.comp_1933()).method_8111((class_9695)copyOfPatternSlots.method_59961())) {
            if (!class_1799.method_7984((class_1799)itemStack, (class_1799)remainingItem) || !class_1799.method_31577((class_1799)itemStack, (class_1799)remainingItem)) continue;
            return true;
        }
        return false;
    }

    private boolean isInput(class_1799 itemStack) {
        if (this.craftingRecipe == null) {
            return false;
        }
        for (int i = 0; i < this.patternSlots.method_5439(); ++i) {
            if (!(this.ignoreNBT ? class_1799.method_7984((class_1799)itemStack, (class_1799)this.patternSlots.method_5438(i)) : class_1799.method_7984((class_1799)itemStack, (class_1799)this.patternSlots.method_5438(i)) && class_1799.method_31577((class_1799)itemStack, (class_1799)this.patternSlots.method_5438(i)))) continue;
            return true;
        }
        return false;
    }

    private class_1277 replaceCraftingPatternWithCurrentNBTItems(class_1277 container) {
        class_1277 copyOfContainer = new class_1277(container.method_5439());
        for (int i = 0; i < container.method_5439(); ++i) {
            copyOfContainer.method_5447(i, container.method_5438(i).method_7972());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.method_5439(); ++i) {
            int usedCount;
            class_1799 testItemStack;
            int j;
            class_1799 itemStack = copyOfContainer.method_5438(i);
            if (itemStack.method_7960()) continue;
            for (j = 0; j < this.itemHandler.method_5439(); ++j) {
                testItemStack = this.itemHandler.method_5438(j).method_7972();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.method_7939(testItemStack.method_7947() - usedCount);
                if (testItemStack.method_7947() <= 0 || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.itemHandler.method_5439(); ++j) {
                testItemStack = this.itemHandler.method_5438(j).method_7972();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.method_7939(testItemStack.method_7947() - usedCount);
                if (testItemStack.method_7947() <= 0 || !class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.method_5447(i, testItemStack.method_46651(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<class_8786<class_3955>> getRecipesFor(class_1715 patternSlots, class_1937 level) {
        return level.method_8433().method_30027(class_3956.field_17545).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.comp_1932())).filter(recipe -> ((class_3955)recipe.comp_1933()).method_8115((class_9695)patternSlots.method_59961(), level)).sorted(Comparator.comparing(recipe -> ((class_3955)recipe.comp_1933()).method_8110((class_7225.class_7874)level.method_30349()).method_7922())).toList();
    }

    private Optional<Pair<class_2960, class_8786<class_3955>>> getRecipeFor(class_1715 patternSlots, class_1937 level, class_2960 recipeId) {
        List<class_8786<class_3955>> recipes = this.getRecipesFor(patternSlots, level);
        Optional<class_8786> recipe = recipes.stream().filter(r -> r.comp_1932().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.comp_1932(), (Object)r));
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.updateRecipe();
        AutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
                break;
            }
            case 1: {
                this.setSecondaryExtractMode(checked);
            }
        }
    }
}

