/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.CoalEngineMenu;
import me.jddev0.ep.util.ByteUtils;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class CoalEngineBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue();
    final InputOutputItemHandler itemHandlerSided;
    private int progress;
    private int maxProgress;
    private long energyProductionLeft;
    private boolean hasEnoughCapacityForProduction;

    public CoalEngineBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.COAL_ENGINE_ENTITY, blockPos, blockState, "coal_engine", ModConfigs.COMMON_COAL_ENGINE_CAPACITY.getValue(), ModConfigs.COMMON_COAL_ENGINE_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 item = this.itemHandler.method_5438(i.intValue());
            Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
            return burnTime == null || burnTime <= 0;
        });
        this.energyProductionLeft = -1L;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * CoalEngineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                CoalEngineBlockEntity.this.method_5431();
                CoalEngineBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate){

            @Override
            public long getMaxExtract() {
                return Math.max(1L, (long)Math.ceil((double)this.maxExtract * CoalEngineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
                    return burnTime != null && burnTime > 0;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                CoalEngineBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(CoalEngineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(CoalEngineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(CoalEngineBlockEntity.this.energyProductionLeft, index - 4);
                    case 8 -> {
                        if (CoalEngineBlockEntity.this.hasEnoughCapacityForProduction) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> CoalEngineBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> CoalEngineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        CoalEngineBlockEntity.this.progress = ByteUtils.with2Bytes(CoalEngineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        CoalEngineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(CoalEngineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        CoalEngineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        CoalEngineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new CoalEngineMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.max_progress", (class_2520)class_2497.method_23247((int)this.maxProgress));
        nbt.method_10566("recipe.energy_production_left", (class_2520)class_2503.method_23251((long)this.energyProductionLeft));
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.progress = nbt.method_10550("recipe.progress");
        this.maxProgress = nbt.method_10550("recipe.max_progress");
        this.energyProductionLeft = nbt.method_10537("recipe.energy_production_left");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            CoalEngineBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        CoalEngineBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.maxProgress > 0 || CoalEngineBlockEntity.hasRecipe(blockEntity)) {
            class_1799 item = blockEntity.itemHandler.method_5438(0);
            Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
            long energyProduction = burnTime == null ? -1L : (long)burnTime.intValue();
            energyProduction = (long)((double)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
            if (blockEntity.progress == 0) {
                blockEntity.energyProductionLeft = energyProduction;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = energyProduction / 100L <= blockEntity.limitingEnergyStorage.getMaxExtract() ? 100 : (int)Math.ceil((double)energyProduction / (double)blockEntity.limitingEnergyStorage.getMaxExtract());
            }
            long energyProductionPerTick = (long)Math.ceil((double)blockEntity.energyProductionLeft / (double)(blockEntity.maxProgress - blockEntity.progress));
            if (blockEntity.progress == blockEntity.maxProgress - 1) {
                energyProductionPerTick = blockEntity.energyProductionLeft;
            }
            if (energyProductionPerTick <= blockEntity.limitingEnergyStorage.getCapacity() - ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                if (blockEntity.progress == 0) {
                    if (!item.getRecipeRemainder().method_7960()) {
                        blockEntity.itemHandler.method_5447(0, item.getRecipeRemainder());
                    } else {
                        blockEntity.itemHandler.method_5434(0, 1);
                    }
                }
                blockEntity.hasEnoughCapacityForProduction = true;
                if (level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && !((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyProductionLeft < 0L || energyProductionPerTick < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).insert(energyProductionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyProductionLeft -= energyProductionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.resetProgress(blockPos, state);
                }
                CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughCapacityForProduction = false;
                if (level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && ((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
                }
                CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            if (level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && ((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
            }
            CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        LinkedList<EnergyStorage> consumerItems = new LinkedList<EnergyStorage>();
        LinkedList<Long> consumerEnergyValues = new LinkedList<Long>();
        long consumptionSum = 0L;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
        }
        LinkedList<Long> consumerEnergyDistributed = new LinkedList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyProductionLeft = -1L;
        this.hasEnoughCapacityForProduction = false;
    }

    private static boolean hasRecipe(CoalEngineBlockEntity blockEntity) {
        class_1799 item = blockEntity.itemHandler.method_5438(0);
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
        if (burnTime == null || burnTime <= 0) {
            return false;
        }
        return item.getRecipeRemainder().method_7960() || item.method_7947() == 1;
    }
}

