/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.AbstractFluidTankBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.screen.FluidTankMenu;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends AbstractFluidTankBlockEntity<SimpleFluidStorage>
implements CheckboxUpdate {
    private final FluidTankBlock.Tier tier;
    private boolean ignoreNBT;
    private FluidStack fluidFilter = new FluidStack(FluidVariant.blank(), 1L);

    public static class_2591<FluidTankBlockEntity> getEntityTypeFromTier(FluidTankBlock.Tier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case FluidTankBlock.Tier.SMALL -> ModBlockEntities.FLUID_TANK_SMALL_ENTITY;
            case FluidTankBlock.Tier.MEDIUM -> ModBlockEntities.FLUID_TANK_MEDIUM_ENTITY;
            case FluidTankBlock.Tier.LARGE -> ModBlockEntities.FLUID_TANK_LARGE_ENTITY;
        };
    }

    public FluidTankBlockEntity(class_2338 blockPos, class_2680 blockState, FluidTankBlock.Tier tier) {
        super(FluidTankBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState, tier.getResourceId(), FluidStorageSingleTankMethods.INSTANCE, tier.getTankCapacity());
        this.tier = tier;
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FluidTankBlockEntity.this.method_5431();
                FluidTankBlockEntity.this.syncFluidToPlayers(64);
            }

            private boolean isFluidValid(FluidVariant variant) {
                return FluidTankBlockEntity.this.fluidFilter.isEmpty() || (FluidTankBlockEntity.this.ignoreNBT ? FluidTankBlockEntity.this.fluidFilter.getFluidVariant().isOf((Object)variant.getFluid()) && FluidTankBlockEntity.this.fluidFilter.getFluidVariant().componentsMatch(variant.getComponents()) : FluidTankBlockEntity.this.fluidFilter.getFluidVariant().isOf((Object)variant.getFluid()));
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> {
                        if (FluidTankBlockEntity.this.ignoreNBT) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidTankBlockEntity.this.ignoreNBT = value != 0;
                    }
                }
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncFluidToPlayer(player);
        ModMessages.sendServerPacketToPlayer((class_3222)player, new FluidSyncS2CPacket(1, this.fluidFilter, 0L, this.method_11016()));
        return new FluidTankMenu(id, inventory, this, this.data);
    }

    public FluidTankBlock.Tier getTier() {
        return this.tier;
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10556("ignore_nbt", this.ignoreNBT);
        nbt.method_10566("fluid_filter", (class_2520)this.fluidFilter.toNBT(new class_2487(), registries));
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.ignoreNBT = nbt.method_10577("ignore_nbt");
        this.fluidFilter = FluidStack.fromNbt(nbt.method_10562("fluid_filter"), registries);
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        FluidTankBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
            }
        }
    }

    public void setFluidFilter(FluidStack fluidFilter, class_5455 registries) {
        this.fluidFilter = new FluidStack(fluidFilter.getFluid(), fluidFilter.getFluidVariant().getComponents(), fluidFilter.getDropletsAmount());
        FluidTankBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
        ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, 32.0, new FluidSyncS2CPacket(1, fluidFilter, 0L, this.method_11016()));
    }

    @Override
    public FluidStack getFluid(int tank) {
        return switch (tank) {
            case 0 -> super.getFluid(tank);
            case 1 -> this.fluidFilter;
            default -> null;
        };
    }

    @Override
    public long getTankCapacity(int tank) {
        if (tank == 0) {
            return super.getTankCapacity(tank);
        }
        return 0L;
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        switch (tank) {
            case 0: {
                super.setFluid(tank, fluidStack);
                break;
            }
            case 1: {
                this.fluidFilter = new FluidStack(fluidStack.getFluid(), fluidStack.getFluidVariant().getComponents(), fluidStack.getDropletsAmount());
            }
        }
    }

    @Override
    public void setTankCapacity(int tank, long capacity) {
        if (tank == 0) {
            super.setTankCapacity(tank, capacity);
        }
    }
}

