/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.MinecartChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.entity.AbstractMinecartBatteryBox;
import me.jddev0.ep.screen.MinecartChargerMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class MinecartChargerBlockEntity
extends MenuEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    public static final long MAX_TRANSFER = ModConfigs.COMMON_MINECART_CHARGER_TRANSFER_RATE.getValue();
    private boolean hasMinecartOld = true;
    private boolean hasMinecart = false;

    public MinecartChargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.MINECART_CHARGER_ENTITY, blockPos, blockState, "minecart_charger", ModConfigs.COMMON_MINECART_CHARGER_CAPACITY.getValue(), MAX_TRANSFER);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            protected void onFinalCommit() {
                MinecartChargerBlockEntity.this.method_5431();
                MinecartChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L);
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new MinecartChargerMenu(id, this, inventory);
    }

    public int getRedstoneOutput() {
        class_2338 blockPosFacing = this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)MinecartChargerBlock.FACING));
        List minecarts = this.field_11863.method_18023(class_5575.method_31795(AbstractMinecartBatteryBox.class), new class_238((double)blockPosFacing.method_10263(), (double)blockPosFacing.method_10264(), (double)blockPosFacing.method_10260(), (double)(blockPosFacing.method_10263() + 1), (double)(blockPosFacing.method_10264() + 1), (double)(blockPosFacing.method_10260() + 1)), class_1301.field_6154);
        if (minecarts.isEmpty()) {
            return 0;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        long minecartEnergy = minecart.getEnergy();
        boolean isEmptyFlag = minecartEnergy == 0L;
        return Math.min(class_3532.method_15375((float)((float)minecartEnergy / (float)minecart.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, MinecartChargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.hasMinecartOld != blockEntity.hasMinecart) {
            MinecartChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        blockEntity.hasMinecartOld = blockEntity.hasMinecart;
        class_2338 blockPosFacing = blockEntity.method_11016().method_10093((class_2350)blockEntity.method_11010().method_11654((class_2769)MinecartChargerBlock.FACING));
        List minecarts = level.method_18023(class_5575.method_31795(AbstractMinecartBatteryBox.class), new class_238((double)blockPosFacing.method_10263(), (double)blockPosFacing.method_10264(), (double)blockPosFacing.method_10260(), (double)(blockPosFacing.method_10263() + 1), (double)(blockPosFacing.method_10264() + 1), (double)(blockPosFacing.method_10260() + 1)), class_1301.field_6154);
        boolean bl = blockEntity.hasMinecart = !minecarts.isEmpty();
        if (!blockEntity.hasMinecart) {
            return;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        long transferred = Math.min(Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), blockEntity.limitingEnergyStorage.getMaxInsert()), Math.min(minecart.getTransferRate(), minecart.getCapacity() - minecart.getEnergy()));
        minecart.setEnergy(minecart.getEnergy() + transferred);
        if (transferred < 0L) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(transferred, (TransactionContext)transaction);
            transaction.commit();
        }
    }
}

