/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.SolarPanelBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.SolarPanelMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class SolarPanelBlockEntity
extends UpgradableEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    private final SolarPanelBlock.Tier tier;

    public static class_2591<SolarPanelBlockEntity> getEntityTypeFromTier(SolarPanelBlock.Tier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case SolarPanelBlock.Tier.TIER_1 -> ModBlockEntities.SOLAR_PANEL_ENTITY_1;
            case SolarPanelBlock.Tier.TIER_2 -> ModBlockEntities.SOLAR_PANEL_ENTITY_2;
            case SolarPanelBlock.Tier.TIER_3 -> ModBlockEntities.SOLAR_PANEL_ENTITY_3;
            case SolarPanelBlock.Tier.TIER_4 -> ModBlockEntities.SOLAR_PANEL_ENTITY_4;
            case SolarPanelBlock.Tier.TIER_5 -> ModBlockEntities.SOLAR_PANEL_ENTITY_5;
            case SolarPanelBlock.Tier.TIER_6 -> ModBlockEntities.SOLAR_PANEL_ENTITY_6;
        };
    }

    public SolarPanelBlockEntity(class_2338 blockPos, class_2680 blockState, SolarPanelBlock.Tier tier) {
        super(SolarPanelBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState, tier.getResourceId(), tier.getCapacity(), tier.getMaxTransfer(), UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.MOON_LIGHT);
        this.tier = tier;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * SolarPanelBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                SolarPanelBlockEntity.this.method_5431();
                SolarPanelBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate){

            @Override
            public long getMaxExtract() {
                return Math.max(1L, (long)Math.ceil((double)this.maxExtract * SolarPanelBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    public SolarPanelBlock.Tier getTier() {
        return this.tier;
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new SolarPanelMenu(id, this, inventory, this.upgradeModuleInventory);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, SolarPanelBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        int i = 4 * (level.method_8314(class_1944.field_9284, blockPos) - level.method_8594());
        float f = level.method_8442(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * class_3532.method_15362((float)f));
        }
        i = class_3532.method_15340((int)i, (int)0, (int)60);
        long energyProduction = (long)((float)i / 60.0f * (float)blockEntity.getTier().getPeakFePerTick());
        double moonLightUpgradeModuleEffect = blockEntity.upgradeModuleInventory.getUpgradeModuleModifierEffect(1, UpgradeModuleModifier.MOON_LIGHT);
        if (moonLightUpgradeModuleEffect > 0.0 && (i = 15 - (level.method_8314(class_1944.field_9284, blockPos) - level.method_8594())) < 14) {
            i = class_3532.method_15340((int)i, (int)0, (int)15);
            energyProduction += (long)((double)i / 15.0 * (double)blockEntity.getTier().getPeakFePerTick() * moonLightUpgradeModuleEffect);
        }
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).insert(energyProduction, (TransactionContext)transaction);
            transaction.commit();
        }
        SolarPanelBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, SolarPanelBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        class_2338 testPos = blockPos.method_10093(class_2350.field_11033);
        class_2586 testBlockEntity = level.method_8321(testPos);
        if (testBlockEntity == null) {
            return;
        }
        EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)class_2350.field_11033.method_10153());
        if (limitingEnergyStorage == null) {
            return;
        }
        if (!limitingEnergyStorage.supportsInsertion()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long amount = limitingEnergyStorage.insert(Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), blockEntity.limitingEnergyStorage.getMaxExtract()), (TransactionContext)transaction);
            blockEntity.limitingEnergyStorage.extract(amount, (TransactionContext)transaction);
            transaction.commit();
        }
    }
}

