/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleRecipeMachineBlockEntity<C extends class_9695, R extends class_1860<C>>
extends WorkerMachineBlockEntity<class_8786<R>> {
    protected final UpgradableMenuProvider menuProvider;
    protected final class_3956<R> recipeType;

    public SimpleRecipeMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, class_3956<R> recipeType, int baseRecipeDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                return slot == 0 && (SimpleRecipeMachineBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(SimpleRecipeMachineBlockEntity.this.field_11863, SimpleRecipeMachineBlockEntity.this.recipeType, stack));
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        SimpleRecipeMachineBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                SimpleRecipeMachineBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(SimpleRecipeMachineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(SimpleRecipeMachineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(SimpleRecipeMachineBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (SimpleRecipeMachineBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> SimpleRecipeMachineBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> SimpleRecipeMachineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        SimpleRecipeMachineBlockEntity.this.progress = ByteUtils.with2Bytes(SimpleRecipeMachineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        SimpleRecipeMachineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(SimpleRecipeMachineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        SimpleRecipeMachineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        SimpleRecipeMachineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return this.menuProvider.createMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    protected abstract C getRecipeInput(class_1277 var1);

    protected Optional<class_8786<R>> getRecipeFor(class_1277 inventory) {
        return this.field_11863.method_8433().method_8132(this.recipeType, this.getRecipeInput(inventory), this.field_11863);
    }

    @Override
    protected final Optional<class_8786<R>> getCurrentWorkData() {
        return this.getRecipeFor(this.itemHandler);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(class_8786<R> workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(class_8786<R> workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<class_8786<R>> recipe = this.getRecipeFor(this.itemHandler);
        return recipe.isPresent() && this.canCraftRecipe(this.itemHandler, recipe.get());
    }

    @Override
    protected final void onWorkStarted(class_8786<R> workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(class_8786<R> recipe) {
    }

    @Override
    protected final void onWorkCompleted(class_8786<R> workData) {
        this.craftItem(workData);
    }

    protected void craftItem(class_8786<R> recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.method_5434(0, 1);
        this.itemHandler.method_5447(1, recipe.comp_1933().method_8110((class_7225.class_7874)this.field_11863.method_30349()).method_46651(this.itemHandler.method_5438(1).method_7947() + recipe.comp_1933().method_8110((class_7225.class_7874)this.field_11863.method_30349()).method_7947()));
        this.resetProgress();
    }

    protected boolean canCraftRecipe(class_1277 inventory, class_8786<R> recipe) {
        return this.field_11863 != null && InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 1, recipe.comp_1933().method_8110((class_7225.class_7874)this.field_11863.method_30349()));
    }
}

