/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import de.maxhenkel.voicechat.Voicechat;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public class VoiceChatResourcePack
extends class_3255
implements class_3288.class_7680 {
    public VoiceChatResourcePack(String id, class_2561 name) {
        super(new class_9224(id, name, class_5352.field_25348, Optional.empty()));
    }

    public class_3288 toPack() {
        int packVersion = class_155.method_16673().method_48017(class_3264.field_14188);
        class_3288.class_7679 meta = class_3288.method_45274((class_9224)this.method_56926(), (class_3288.class_7680)this, (int)packVersion);
        if (meta == null) {
            throw new IllegalStateException("Could not find builtin resource pack info");
        }
        return class_3288.method_45275((class_9224)this.method_56926(), (class_3288.class_7680)this, (class_3264)class_3264.field_14188, (class_9225)new class_9225(false, class_3288.class_3289.field_14280, false));
    }

    private String getPath() {
        return "/packs/" + this.method_14409() + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        return this.getResource(String.join((CharSequence)"/", strings));
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 resourceLocation) {
        return this.method_14410(packType.method_14413(), resourceLocation.method_12836(), resourceLocation.method_12832());
    }

    @Nullable
    private class_7367<InputStream> getResource(String path) {
        InputStream resourceAsStream = this.get(path);
        if (resourceAsStream == null) {
            return null;
        }
        return () -> resourceAsStream;
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 resourceOutput) {
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            if (url == null) {
                return;
            }
            Path namespacePath = Paths.get(url.toURI()).resolve(type.method_14413()).resolve(namespace);
            Path resPath = namespacePath.resolve(prefix);
            if (!Files.exists(resPath, new LinkOption[0])) {
                return;
            }
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    class_2960 resourceLocation = class_2960.method_60655((String)namespace, (String)VoiceChatResourcePack.convertPath(path).substring(VoiceChatResourcePack.convertPath(namespacePath).length() + 1));
                    resourceOutput.accept((Object)resourceLocation, this.method_14405(type, resourceLocation));
                });
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to list builtin pack resources", e);
        }
    }

    private static String convertPath(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < path.getNameCount(); ++i) {
            stringBuilder.append(path.getName(i));
            if (i >= path.getNameCount() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public Set<String> method_14406(class_3264 packType) {
        if (packType == class_3264.field_14188) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }

    public class_3262 method_52424(class_9224 packLocationInfo) {
        return this;
    }

    public class_3262 method_52425(class_9224 packLocationInfo, class_3288.class_7679 metadata) {
        return this;
    }
}

