/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.TaigaTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class RedwoodTreeFeature
extends BOPTreeFeature<TaigaTreeConfiguration> {
    public RedwoodTreeFeature(Codec<TaigaTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(class_1936 world, class_2338 pos, int baseHeight, int height, TaigaTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = config.trunkWidth * (height - y) / height + 1;
            int trunkStart = class_3532.method_15384((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = class_3532.method_15357((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (pos1.method_10264() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(class_1936 world, class_5819 rand, class_2338 pos, int leavesRadius, int trunkStart, int trunkEnd, class_4647.class_8179 leaves, TaigaTreeConfiguration config) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.method_43048(2) != 0)) continue;
                this.placeLeaves(world, pos.method_10069(x, 0, z), leaves, config);
            }
        }
    }

    public void generateBranch(class_1936 world, class_5819 rand, class_2338 pos, class_2350 direction, int length, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, TaigaTreeConfiguration config) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2350 sideways = direction.method_10170();
        for (int i = 1; i <= length; ++i) {
            class_2338 pos1 = pos.method_10079(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.method_43048(2) != 0) continue;
                this.placeLeaves(world, pos1.method_10079(sideways, j), leaves, config);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.method_10084(), leaves, config);
            this.placeLeaves(world, pos1.method_10084().method_10079(sideways, -1), leaves, config);
            this.placeLeaves(world, pos1.method_10084().method_10079(sideways, 1), leaves, config);
            this.placeLog(world, pos1, axis, logs, config);
        }
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 startPos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        int baseHeight;
        TaigaTreeConfiguration config = (TaigaTreeConfiguration)configBase;
        while (startPos.method_10264() >= world.method_31607() + 1 && world.method_22347(startPos) || world.method_8320(startPos).method_26164(class_3481.field_15503)) {
            startPos = startPos.method_10074();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f)));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace((class_1936)world, startPos.method_10084(), baseHeight, height, config)) {
            return false;
        }
        class_2338 pos = startPos.method_10086(height);
        this.placeLeaves((class_1936)world, pos, leaves, config);
        pos.method_10074();
        for (int i = 0; i < leavesHeight; ++i) {
            int trunkWidth = config.trunkWidth * i / height + 1;
            int trunkStart = class_3532.method_15384((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = class_3532.method_15357((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 4, 2 + (leavesHeight - i)), 4);
            if (radius == 0) {
                this.placeLeaves((class_1936)world, pos, leaves, config);
            } else if (radius < 2) {
                this.generateLeafLayer((class_1936)world, random, pos, radius, trunkStart, trunkEnd, leaves, config);
            } else if (i % 5 == 0) {
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkStart, 0, trunkStart), class_2350.field_11043, radius / 2, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkEnd, 0, trunkStart), class_2350.field_11034, radius / 2, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkEnd, 0, trunkEnd), class_2350.field_11035, radius / 2, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkStart, 0, trunkEnd), class_2350.field_11039, radius / 2, logs, leaves, config);
            } else {
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkStart, 0, trunkStart), class_2350.field_11043, radius, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkEnd, 0, trunkStart), class_2350.field_11034, radius, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkEnd, 0, trunkEnd), class_2350.field_11035, radius, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkStart, 0, trunkEnd), class_2350.field_11039, radius, logs, leaves, config);
            }
            pos = pos.method_10074();
        }
        double[] scalingFactors = new double[]{0.35 + random.method_43058() * 0.15, 0.07 + random.method_43058() * 0.1, random.method_43058() * 0.06};
        if (config.trunkWidth == 3) {
            scalingFactors = new double[]{0.6 + random.method_43058() * 0.2, 0.1 + random.method_43058() * 0.2, 0.03 + random.method_43058() * 0.09};
        }
        for (int x = -config.trunkWidth; x <= config.trunkWidth; ++x) {
            for (int z = -config.trunkWidth; z <= config.trunkWidth; ++z) {
                class_2338 local;
                int y;
                int dist = Math.abs(x) + Math.abs(z);
                int heightHere = height - 2;
                if (config.trunkWidth == 1 && dist > 0) continue;
                if (dist == 1) {
                    heightHere = (int)((double)height * scalingFactors[0]);
                } else if (dist == 2) {
                    heightHere = (int)((double)height * scalingFactors[1]);
                } else if (dist == 3) {
                    heightHere = (int)((double)height * scalingFactors[2]);
                } else if (dist > 3) continue;
                heightHere += random.method_43048(2);
                boolean didPlace = false;
                for (y = 0; y < heightHere; ++y) {
                    double theta;
                    local = startPos.method_10069(x, y, z);
                    didPlace |= this.placeLog((class_1936)world, local, logs, config);
                    if (dist <= 0 || y <= 6 || y >= baseHeight - 2 || random.method_43048(15) != 0) continue;
                    if (x == 0 && z == 0) {
                        if (y < 10) continue;
                        theta = Math.PI * random.method_43058() * 2.0;
                    } else {
                        double angleFromCenter = Math.atan2(x, z);
                        theta = angleFromCenter + Math.PI * (random.method_43058() * 0.5 - 0.25);
                    }
                    int branchLength = 3 - dist + 1 + random.method_43048(2);
                    class_2338 branchPos = null;
                    for (int i = 0; i < branchLength; ++i) {
                        branchPos = local.method_10069(class_3532.method_15357((double)(Math.cos(theta) * (double)i)), i / 2, class_3532.method_15357((double)(Math.sin(theta) * (double)i)));
                        this.placeLog((class_1936)world, branchPos, logs, config);
                    }
                    this.generateBush(logs, leaves, (class_1936)world, random, branchPos, config);
                }
                if (!didPlace) continue;
                for (y = 1; y < 4; ++y) {
                    local = startPos.method_10069(x, -y, z);
                    class_2680 state = world.method_8320(local);
                    if (state.method_51367() && !RedwoodTreeFeature.method_23396((class_2680)state)) continue;
                    world.method_8652(local, class_2246.field_10566.method_9564(), 3);
                }
            }
        }
        return true;
    }

    protected boolean generateBush(BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_1936 world, class_5819 random, class_2338 pos, TaigaTreeConfiguration config) {
        int height = 2;
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.placeLog(world, pos.method_10069(0, y, 0), logs, config);
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius) continue;
                    if (config.altFoliageProvider.method_23455(random, pos) != class_2246.field_10124.method_9564()) {
                        if (random.method_43048(4) == 0) {
                            this.placeAltLeaves(world, pos.method_10069(x, y, z), leaves, config);
                            continue;
                        }
                        this.placeLeaves(world, pos.method_10069(x, y, z), leaves, config);
                        continue;
                    }
                    this.placeLeaves(world, pos.method_10069(x, y, z), leaves, config);
                }
            }
        }
        return true;
    }
}

