/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.preload.ResourcePreLoader;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_4071;
import net.minecraft.class_4080;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public class MixinMinecraft {
    @Unique
    private static final String DUMMY_RESOURCE_RELOAD_LISTENER_RETURN_VALUE_FANCYMENU = "PREPARE RETURN VALUE";
    @Unique
    private static final Logger LOGGER_FANCYMENU = LogManager.getLogger();
    @Unique
    private static boolean reloadListenerRegisteredFancyMenu = false;
    @Unique
    private boolean lateClientInitDoneFancyMenu = false;
    @Shadow
    @Nullable
    public class_437 field_1755;

    @Inject(method={"setOverlay"}, at={@At(value="HEAD")})
    private void beforeSetOverlayFancyMenu(class_4071 overlay, CallbackInfo info) {
        if (!this.lateClientInitDoneFancyMenu) {
            this.lateClientInitDoneFancyMenu = true;
            FancyMenu.lateClientInit();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void beforeGameTickFancyMenu(CallbackInfo info) {
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                LOGGER_FANCYMENU.error("[FANCYMENU] Error while executing PRE_CLIENT_TICK MainThread task!", (Throwable)e);
            }
        }
        EventHandler.INSTANCE.postEvent(new ClientTickEvent.Pre());
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void afterGameTickFancyMenu(CallbackInfo info) {
        EventHandler.INSTANCE.postEvent(new ClientTickEvent.Post());
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                LOGGER_FANCYMENU.error("[FANCYMENU] Error while executing POST_CLIENT_TICK MainThread task!", (Throwable)e);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V")})
    private void beforeScreenTickFancyMenu(CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Pre(this.field_1755));
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    private void afterScreenTickFancyMenu(CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Post(this.field_1755));
    }

    @Inject(at={@At(value="HEAD")}, method={"createTitle"}, cancellable=true)
    private void changeWindowTitleFancyMenu(CallbackInfoReturnable<String> info) {
        String title = WindowHandler.getCustomWindowTitle();
        if (title != null) {
            info.setReturnValue((Object)title);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void headSetScreenFancyMenu(class_437 screen, CallbackInfo info) {
        RenderingUtils.resetGuiScale();
        class_437 overrideWith = CustomGuiHandler.beforeSetScreen(screen);
        if (overrideWith != null) {
            info.cancel();
            class_310.method_1551().method_1507(overrideWith);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferUploader;reset()V", shift=At.Shift.AFTER)})
    private void beforeInitCurrentScreenFancyMenu(class_437 screen, CallbackInfo info) {
        if (screen != null) {
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;updateTitle()V")})
    private void afterInitCurrentScreenFancyMenu(class_437 screen, CallbackInfo info) {
        if (screen != null) {
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new OpenScreenPostInitEvent(screen));
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V")})
    private void beforeScreenRemovedFancyMenu(class_437 screen, CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new CloseScreenEvent(this.field_1755));
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;added()V")})
    private void beforeScreenAddedFancyMenu(class_437 screen, CallbackInfo info) {
        if (this.field_1755 == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new OpenScreenEvent(this.field_1755));
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;setGuiScale(D)V", shift=At.Shift.AFTER)})
    private void beforeResizeCurrentScreenFancyMenu(CallbackInfo info) {
        if (this.field_1755 != null) {
            RenderingUtils.resetGuiScale();
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;")})
    private void afterResizeCurrentScreenFancyMenu(CallbackInfo info) {
        if (this.field_1755 != null) {
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(this.field_1755, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="HEAD")})
    private void registerResourceReloadListenerInResizeDisplayFancyMenu(CallbackInfo info) {
        if (!reloadListenerRegisteredFancyMenu) {
            reloadListenerRegisteredFancyMenu = true;
            class_310 mc = (class_310)this;
            LOGGER_FANCYMENU.info("[FANCYMENU] Registering resource reload listener..");
            class_3300 class_33002 = mc.method_1478();
            if (class_33002 instanceof class_3304) {
                class_3304 r = (class_3304)class_33002;
                r.method_14477((class_3302)new class_4080<String>(this){

                    @NotNull
                    protected String prepare(@NotNull class_3300 var1, @NotNull class_3695 var2) {
                        return MixinMinecraft.DUMMY_RESOURCE_RELOAD_LISTENER_RETURN_VALUE_FANCYMENU;
                    }

                    protected void apply(@NotNull String prepareReturnValue, @NotNull class_3300 var2, @NotNull class_3695 var3) {
                        ResourceHandlers.reloadAll();
                        ResourcePreLoader.preLoadAll(120000L);
                    }
                });
            }
        }
    }
}

