/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemoscarpentry.screen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.nemonotfound.nemoscarpentry.NemosCarpentry;
import com.nemonotfound.nemoscarpentry.item.SawItem;
import com.nemonotfound.nemoscarpentry.recipe.CarpentryRecipe;
import com.nemonotfound.nemoscarpentry.screen.slots.ToolSlot;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3915;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class CarpentryScreenHandler
extends class_1703 {
    final class_1263 inventory;
    private final class_1937 world;
    private final class_3915 selectedRecipe = class_3915.method_17403();
    private class_1799 inputStack = class_1799.field_8037;
    private class_1799 secondInputStack = class_1799.field_8037;
    private List<class_8786<CarpentryRecipe>> availableRecipes = Lists.newArrayList();
    long lastTakeTime;
    final class_1735 inputSlotOne;
    final class_1735 inputSlotTwo;
    final class_1735 outputSlot;
    Runnable contentsChangedListener = () -> {};
    public final class_1263 input = new class_1277(2){

        public void method_5431() {
            super.method_5431();
            CarpentryScreenHandler.this.method_7609((class_1263)this);
            CarpentryScreenHandler.this.contentsChangedListener.run();
        }
    };
    final class_1731 output = new class_1731();

    public CarpentryScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(4));
    }

    public CarpentryScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory) {
        super(NemosCarpentry.CARPENTRY_SCREEN_HANDLER, syncId);
        CarpentryScreenHandler.method_17359((class_1263)inventory, (int)4);
        this.inventory = inventory;
        inventory.method_5435(playerInventory.field_7546);
        this.world = playerInventory.field_7546.method_37908();
        this.method_7621(new ToolSlot(inventory, 0, -20, 14));
        this.method_7621(new ToolSlot(inventory, 1, -20, 37));
        this.method_7621(new ToolSlot(inventory, 2, -20, 60));
        this.method_7621(new ToolSlot(inventory, 3, -20, 83));
        this.inputSlotOne = this.method_7621(new class_1735(this.input, 0, 20, 19));
        this.inputSlotTwo = this.method_7621(new class_1735(this.input, 1, 20, 47));
        this.outputSlot = this.method_7621(new class_1735((class_1263)this.output, 0, 143, 33){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                long l;
                CarpentryRecipe recipe = (CarpentryRecipe)CarpentryScreenHandler.this.availableRecipes.get(CarpentryScreenHandler.this.selectedRecipe.method_17407()).comp_1933();
                stack.method_7982(player.method_37908(), player, stack.method_7947());
                List<Pair<class_1856, Integer>> ingredients = recipe.getIngredientPairs();
                this.takeStacksOfIngredients(ingredients);
                if (recipe.getTool().equals("saw") && this.getOptionalSawSlot().isPresent()) {
                    this.getOptionalSawSlot().get().method_7677().method_7970(1, (class_1309)player, class_1304.field_6173);
                }
                if (CarpentryScreenHandler.this.lastTakeTime != (l = CarpentryScreenHandler.this.world.method_8510())) {
                    CarpentryScreenHandler.this.world.method_8396(null, player.method_24515(), class_3417.field_17710, class_3419.field_15245, 1.0f, 1.0f);
                    CarpentryScreenHandler.this.lastTakeTime = l;
                }
                super.method_7667(player, stack);
            }

            private void takeStacksOfIngredients(List<Pair<class_1856, Integer>> ingredientPairs) {
                int firstIngredientCount = (Integer)ingredientPairs.get(0).getSecond();
                class_1799 itemStack = CarpentryScreenHandler.this.inputSlotOne.method_7671(firstIngredientCount);
                if (ingredientPairs.size() > 1) {
                    int secondIngredientCount = (Integer)ingredientPairs.get(1).getSecond();
                    CarpentryScreenHandler.this.inputSlotTwo.method_7671(secondIngredientCount);
                }
                if (!itemStack.method_7960()) {
                    CarpentryScreenHandler.this.populateResult();
                }
            }

            public boolean method_7674(class_1657 playerEntity) {
                CarpentryRecipe recipe = (CarpentryRecipe)CarpentryScreenHandler.this.availableRecipes.get(CarpentryScreenHandler.this.selectedRecipe.method_17407()).comp_1933();
                if (recipe.getTool().equals("saw") && this.getOptionalSawSlot().isEmpty()) {
                    long l = CarpentryScreenHandler.this.world.method_8510();
                    if (CarpentryScreenHandler.this.lastTakeTime != l) {
                        CarpentryScreenHandler.this.world.method_8396(null, playerEntity.method_24515(), class_3417.field_17711, class_3419.field_15245, 1.0f, 4.0f);
                        CarpentryScreenHandler.this.lastTakeTime = l;
                    }
                    return false;
                }
                return super.method_7674(playerEntity);
            }

            private Optional<class_1735> getOptionalSawSlot() {
                return CarpentryScreenHandler.this.field_7761.stream().filter(slot -> slot instanceof ToolSlot).filter(slot -> slot.method_7677().method_7909() instanceof SawItem).findFirst();
            }
        });
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.selectedRecipe.method_17404(-1);
        this.method_17362(this.selectedRecipe);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 movingSlot = (class_1735)this.field_7761.get(slotIndex);
        if (movingSlot.method_7681()) {
            class_1799 movingItemStack = movingSlot.method_7677();
            class_1792 item = movingItemStack.method_7909();
            itemStack = movingItemStack.method_7972();
            boolean isToolSlot = movingSlot instanceof ToolSlot;
            if (movingItemStack.method_7909() instanceof SawItem && !isToolSlot && !this.method_7616(movingItemStack, 0, 4, false)) {
                return class_1799.field_8037;
            }
            if (slotIndex == 6) {
                item.method_7843(movingItemStack, player.method_37908());
                if (!this.method_7616(movingItemStack, 7, 43, true)) {
                    return class_1799.field_8037;
                }
                movingSlot.method_7670(movingItemStack, itemStack);
            }
            if ((slotIndex == 4 || slotIndex == 5 || isToolSlot) && !this.method_7616(movingItemStack, 7, 43, false)) {
                return class_1799.field_8037;
            }
            if (this.world.method_8433().method_8132(NemosCarpentry.CARPENTRY, (class_9695)new class_9696(((class_1735)this.field_7761.get(4)).method_7677()), this.world).isPresent() && this.isMovingItemSecondIngredient(((class_1735)this.field_7761.get(4)).method_7677(), movingItemStack) ? !this.method_7616(movingItemStack, 5, 6, false) : (this.world.method_8433().method_8132(NemosCarpentry.CARPENTRY, (class_9695)new class_9696(movingItemStack), this.world).isPresent() ? !this.method_7616(movingItemStack, 4, 5, false) : (slotIndex >= 7 && slotIndex < 34 ? !this.method_7616(movingItemStack, 34, 43, false) : slotIndex >= 34 && slotIndex < 43 && !this.method_7616(movingItemStack, 7, 34, false)))) {
                return class_1799.field_8037;
            }
            if (movingItemStack.method_7960()) {
                movingSlot.method_53512(class_1799.field_8037);
            }
            movingSlot.method_7668();
            if (movingItemStack.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            movingSlot.method_7667(player, itemStack);
            this.method_7623();
        }
        return itemStack;
    }

    private boolean isMovingItemSecondIngredient(class_1799 firstIngredient, class_1799 secondIngredient) {
        List carpentryRecipe = this.world.method_8433().method_17877(NemosCarpentry.CARPENTRY, (class_9695)new class_9696(firstIngredient), this.world);
        return carpentryRecipe.stream().anyMatch(recipe -> this.isItemSecondIngredient(((CarpentryRecipe)recipe.comp_1933()).getIngredientPairs(), secondIngredient));
    }

    private boolean isItemSecondIngredient(List<Pair<class_1856, Integer>> ingredientPairs, class_1799 secondIngredient) {
        return ingredientPairs.size() >= 2 && this.itemIsInMatchingStacks(((class_1856)ingredientPairs.get(1).getFirst()).method_8105(), secondIngredient.method_7909());
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public boolean method_7604(class_1657 player, int index) {
        if (this.isInBounds(index)) {
            if (this.canCraftRecipe(index)) {
                this.selectedRecipe.method_17404(index);
            } else {
                this.selectedRecipe.method_17404(-1);
            }
            this.populateResult();
        }
        return true;
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.output.method_5441(0);
        this.method_7607(player, this.input);
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public void method_7609(class_1263 inventory) {
        class_1799 firstIngredient = this.inputSlotOne.method_7677();
        class_1799 secondIngredient = this.inputSlotTwo.method_7677();
        if (!firstIngredient.method_31574(this.inputStack.method_7909()) || !secondIngredient.method_31574(this.secondInputStack.method_7909())) {
            this.inputStack = firstIngredient.method_7972();
            this.secondInputStack = secondIngredient.method_7972();
            this.updateInput(inventory, firstIngredient);
        }
    }

    private static class_9696 createRecipeInput(class_1263 inventory) {
        return new class_9696(inventory.method_5438(0));
    }

    private void updateInput(class_1263 inventory, class_1799 firstIngredient) {
        this.availableRecipes.clear();
        this.selectedRecipe.method_17404(-1);
        this.outputSlot.method_7673(class_1799.field_8037);
        if (!firstIngredient.method_7960()) {
            this.availableRecipes = this.world.method_8433().method_17877(NemosCarpentry.CARPENTRY, (class_9695)CarpentryScreenHandler.createRecipeInput(inventory), this.world);
        }
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.method_17407();
    }

    public List<class_8786<CarpentryRecipe>> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public boolean hasAvailableRecipes() {
        return !this.availableRecipes.isEmpty();
    }

    public boolean canCraftRecipe(int index) {
        boolean hasRecipes = !this.availableRecipes.isEmpty();
        boolean hasFirstInputSlotStack = this.inputSlotOne.method_7681();
        if (!hasRecipes || !hasFirstInputSlotStack) {
            return false;
        }
        return this.hasRecipeIngredients(index);
    }

    public boolean canCraftSelectedRecipe() {
        boolean hasRecipes = !this.availableRecipes.isEmpty();
        boolean hasFirstInputSlotStack = this.inputSlotOne.method_7681();
        int selectedRecipeIndex = this.selectedRecipe.method_17407();
        if (!hasRecipes || !hasFirstInputSlotStack || selectedRecipeIndex == -1) {
            return false;
        }
        return this.hasRecipeIngredients(selectedRecipeIndex);
    }

    private boolean hasRecipeIngredients(int index) {
        class_1799 firstInputItemStack;
        CarpentryRecipe recipe = (CarpentryRecipe)this.availableRecipes.get(index).comp_1933();
        List<Pair<class_1856, Integer>> ingredientPairs = recipe.getIngredientPairs();
        class_1799[] firstIngredientMatchingStacks = ((class_1856)ingredientPairs.get(0).getFirst()).method_8105();
        boolean hasFirstInputIngredient = this.itemIsInMatchingStacks(firstIngredientMatchingStacks, (firstInputItemStack = this.inputSlotOne.method_7677()).method_7909()) && firstInputItemStack.method_7947() >= (Integer)ingredientPairs.get(0).getSecond();
        boolean hasSecondInputIngredient = true;
        if (ingredientPairs.size() > 1) {
            class_1856 secondIngredient = (class_1856)ingredientPairs.get(1).getFirst();
            class_1799 secondInputItemStack = this.inputSlotTwo.method_7677();
            hasSecondInputIngredient = this.itemIsInMatchingStacks(secondIngredient.method_8105(), secondInputItemStack.method_7909()) && secondInputItemStack.method_7947() >= (Integer)ingredientPairs.get(1).getSecond();
        }
        return hasFirstInputIngredient && hasSecondInputIngredient;
    }

    private boolean itemIsInMatchingStacks(class_1799[] matchingStacks, class_1792 item) {
        return Arrays.stream(matchingStacks).anyMatch(itemStack -> itemStack.method_7909().equals(item));
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private void populateResult() {
        if (this.hasAvailableRecipes() && this.isInBounds(this.selectedRecipe.method_17407()) && this.canCraftSelectedRecipe()) {
            class_8786<CarpentryRecipe> recipeEntry = this.availableRecipes.get(this.selectedRecipe.method_17407());
            CarpentryRecipe recipe = (CarpentryRecipe)recipeEntry.comp_1933();
            class_1799 itemStack = recipe.craft(CarpentryScreenHandler.createRecipeInput(this.input), (class_7225.class_7874)this.world.method_30349());
            if (itemStack.method_45435(this.world.method_45162())) {
                this.output.method_7662(recipeEntry);
                this.outputSlot.method_7673(itemStack);
            } else {
                this.outputSlot.method_7673(class_1799.field_8037);
            }
        } else {
            this.outputSlot.method_7673(class_1799.field_8037);
        }
        this.method_7623();
    }
}

