#include "/lib/core.glsl"

#include "/lib/config.glsl"

uniform int worldTime;
uniform float blindness, far, rainStrength;
uniform vec3 fogColor, shadowLightPosition, skyColor;
uniform mat3 normalMatrix;
uniform mat4 modelViewMatrix, projectionMatrix;

in vec3 vaNormal, vaPosition;
in vec4 vaColor;

out VertexData {
	vec4 color;
} fsh;

void main() {
	immut vec4 view = modelViewMatrix * vec4(vaPosition, 1.0);

	immut float fog = pow(length(vaPosition.xz) * 0.6 / far, 10.0 / (10.0 + FOG + blindness * 5000.0 + rainStrength * RAIN_FOG));

	if (fog < 0.999) {
		immut float diffuse = max(dot(normalMatrix * vaNormal, normalize(shadowLightPosition)), 0.5);

		immut float daylight = min(distance(worldTime, 6000.0), 30000.0 - worldTime) / 12000.0;
		immut vec3 sunlight = 0.5 * mix(fogColor, max(1.1 - skyColor - smoothstep(0.4, 0.6, daylight), 0.0), min(daylight + 0.1, 1.0 - rainStrength * 0.9));

		fsh.color = vec4((vaColor.rgb + sunlight * min(diffuse, float(sunlight))) * 0.5 + fogColor, vaColor.a * min(length(view.xyz) * 0.01, 1.0 - fog));
	} else fsh.color = vec4(0.0);

	gl_Position = projectionMatrix * view;
}