#include "/lib/core.glsl"

#include "/lib/config.glsl"
#include "/lib/lightmap.glsl"

uniform int heldBlockLightValue, heldBlockLightValue2, heldItemId, heldItemId2;
uniform float rainStrength;
uniform vec3 shadowLightPosition;
uniform mat3 normalMatrix;
uniform mat4 modelViewMatrix, projectionMatrix;

#if !defined END && !defined NETHER 
	uniform int worldTime;
	uniform vec3 fogColor, skyColor;
#endif

in vec2 vaUV0;
in vec3 vaNormal, vaPosition;
in vec4 vaColor;

out VertexData {
	vec2 coord;
	vec3 color;
} fsh;

void main() {
	gl_Position = projectionMatrix * modelViewMatrix * vec4(vaPosition, 1.0);

	immut float diffuse = dot(normalMatrix * vaNormal, normalize(shadowLightPosition));

	#if defined END || defined NETHER
		vec3 color = vaColor.rgb * mix(max(diffuse, 0.5), 1.0, 0.5);
	#else
		immut float daylight = min(distance(worldTime, 6000.0), 30000.0 - worldTime) / 12000.0;
		//immut vec3 light_color = mix(pow(fogColor, vec3(2.4)), max(1.1 - pow(skyColor, vec3(2.4)) - max(daylight - 0.5, 0.0) * 4.0, 0.0), min(daylight + 0.1, 1.0));
		immut vec3 light_color = mix(pow(fogColor, vec3(2.4)), max(1.1 - pow(skyColor, vec3(2.4)) - smoothstep(0.4, 0.6, daylight), 0.0), min(daylight + 0.1, 1.0 - rainStrength * 0.9));

		const float ambient = AMBIENT * 0.05;

		vec3 color = pow(vaColor.rgb, vec3(2.4));

		if (diffuse > 0.0) {
			immut vec3 sunlight = light_color * SUNLIGHT * 0.1;

			color.rgb *= sunlight * min(diffuse, float(sunlight)) + ambient;
		} else color.rgb *= ambient;

		color = pow(color, vec3(1.0 / 2.4));
	#endif

	immut vec3 light = mix(texture(lightmap, lm_coord).rgb, vec3(1.0), min((heldBlockLightValue + heldBlockLightValue2) / 15.0 + heldItemId + heldItemId2 + 2.0, 1.0));

	#ifdef NETHER
		color *= mix(vec3(1.0, 0.6, 0.76) * AMBIENT * 0.1, light * 1.5, float(light) - 0.75);
	#elif defined END
		color *= mix(vec3(0.76, 0.4, 0.76) * AMBIENT * 0.1, light * 1.5, float(light) - 0.75);
	#else
		color *= light;
	#endif

	fsh.coord = vaUV0;
	fsh.color = color;
}