#include "/lib/core.glsl"

uniform mat4 modelViewMatrix, projectionMatrix;

in vec4 vaColor;

out VertexData {
	vec3 pos, color;
} fsh;

void main() {
	immut vec4 view = modelViewMatrix * vec4(vaPosition, 1.0);
	gl_Position = projectionMatrix * view;

	fsh.pos = view.xyz;
	fsh.color = vaColor.rgb;
}