#include "/lib/core.glsl"

#include "/lib/config.glsl"
#include "/lib/lightmap.glsl"

#ifdef GLOWING_REDSTONE_BLOCK
#endif
#ifdef GLOWING_EMERALD_BLOCK
#endif
#ifdef GLOWING_LAPIS_BLOCK
#endif
#ifdef GLOWING_FLOWERS
#endif
#ifdef GLOWING_FUNGI
#endif

uniform int isEyeInWater;
uniform float blindness, far, rainStrength;
uniform vec3 chunkOffset, shadowLightPosition;
uniform mat3 normalMatrix;
uniform mat4 modelViewMatrix, projectionMatrix, shadowModelView, shadowProjection;

#ifdef ENTITY
	uniform mat4 gbufferModelViewInverse;

	#ifdef COLORED
		uniform vec4 entityColor;
	#endif
#else
	in vec4 at_midBlock, mc_Entity;

	#if defined TRANSLUCENT && !defined ENTITY && WAVES
		uniform float frameTimeCounter;
		uniform vec3 cameraPosition;
	#endif
#endif

in vec2 vaUV0;
in vec3 vaNormal, vaPosition;
in vec4 vaColor;

out VertexData {
	float fog;
	vec2 coord;

	#ifdef TRANSLUCENT
		vec4 color;
	#else
		vec3 color;
	#endif
} fsh;

out ShadowData {
	float diffuse, dist;
	vec3 pos;
} shadow;

#include "/lib/distort.glsl"

void main() {
	vec3 world = vaPosition + chunkOffset;

	#ifdef TRANSLUCENT
		vec4 color = vaColor;

		#ifndef ENTITY
			if (mc_Entity.r == 0) {
				color.a *= WATER_OPACITY * 0.01;

				#if WAVES
					float time = frameTimeCounter * WAVE_SPEED;
					world.y += (sin(cameraPosition.x + world.x + time) * sin(cameraPosition.z + world.z + time) - 1.0) * WAVES * 0.0375;
				#endif
			}
		#endif
	#else
		vec3 color = vaColor.rgb;
	#endif

	#ifdef ENTITY
		immut vec4 view = modelViewMatrix * vec4(world, 1.0);
		vec3 s_view = (shadowProjection * shadowModelView * gbufferModelViewInverse * view).xyz;
	#else
		immut vec4 world_4 = vec4(world, 1.0);
		immut vec4 view = modelViewMatrix * world_4;
		vec3 s_view = (shadowProjection * shadowModelView * world_4).xyz;
	#endif

	immut vec3 normal = normalMatrix * vaNormal;
	immut vec3 sun = normalize(shadowLightPosition); // normalize(shadowLightPosition - view.xyz)

	float diffuse = dot(normal, sun);

	s_view = distort(s_view);
	s_view.z -= max(0.00005, 0.0002 * length(s_view.xy) / abs(diffuse));
	shadow.pos = s_view * 0.5 + 0.5;

	immut vec3 abs_pos = abs(world);
	shadow.dist = max(abs_pos.x, max(abs_pos.y, abs_pos.z)) / (shadowDistance * shadowDistanceRenderMul);

	vec3 light = texture(lightmap, lm_coord).rgb;

	#ifndef ENTITY
		light = mix(light, vec3(1.0), clamp((mc_Entity.r - 1.0 + at_midBlock.w) / 15.0, 0.0, 1.0));
	#elif defined COLORED
		color.rgb = mix(color.rgb, entityColor.rgb, entityColor.a);
	#endif

	#ifdef END
		light = mix(AMBIENT * 0.05 * vec3(0.76, 0.4, 0.76), light * 1.5, float(light) - 0.75);
	#endif

	color.rgb *= light;

	#if SPECULAR
		if(diffuse > 0.0) diffuse += 0.1 * SPECULAR * pow(max(dot(reflect(-sun, normal), normalize(-view.xyz)), 0.0), SHININESS);
	#endif

	shadow.diffuse = diffuse;

	fsh.coord = vaUV0;
	fsh.color = color;
	fsh.fog = min(pow(length(view.xyz) / far, 10.0 / (FOG + blindness * 5000.0 + rainStrength * RAIN_FOG + pow(isEyeInWater, 4) * WATER_FOG)), 1.0);

	gl_Position = projectionMatrix * view;
}