#include "/lib/core.glsl"

#include "/lib/config.glsl"

uniform vec3 chunkOffset;
uniform mat4 modelViewMatrix, projectionMatrix;

#if WAVES
	uniform float frameTimeCounter;
	uniform vec3 cameraPosition;
#endif

in vec2 vaUV0;
in vec3 mc_Entity, vaPosition;
in vec4 vaColor;

out VertexData {
	vec2 coord;
	vec4 color;
} fsh;

#include "/lib/distort.glsl"

void main() {
	vec3 world = vaPosition + chunkOffset;

	float opacity;

	if (mc_Entity.r == 0) {
		opacity = WATER_OPACITY * 0.01;

		#if WAVES
			float time = frameTimeCounter * WAVE_SPEED;
			world.y += (sin(cameraPosition.x + world.x + time) * sin(cameraPosition.z + world.z + time) - 1.0) * WAVES * 0.0375;
		#endif
	} else opacity = 1.0;

	immut vec4 ndc = projectionMatrix * modelViewMatrix * vec4(world, 1.0);
	gl_Position = vec4(distort(ndc.xyz), ndc.w);

	fsh.coord = vaUV0;
	fsh.color = vec4(vaColor.rgb, opacity);
}